#ifndef MFILEDESCR_H
#define MFILEDESCR_H

#include "Magic.h"

#include <fstream.h>

class TFile;
class TTree;
class TBranch;
class MParContainer;

class MFileDescrIn
{
public:
    virtual void SetAddress(MParContainer **obj) {};
    virtual void GetEvent(Int_t n) {};
};

class MFileDescrOut
{
public:
    virtual void SetAddress(MParContainer **obj) {};
    virtual void Fill() {};
};

class MRootFileIn : public MFileDescrIn
{
private:
    TTree   *pTreeIn;     // tree to open for input
    TBranch *pBranchIn;   // branch to open for input

    Int_t nEvts;          // in Tree

public:
    MRootFileIn(TFile *f, const char *fName, const char *cname);
    void SetAddress(MParContainer **obj);
    void GetEvent(Int_t n);
};

class MRootFileOut : public MFileDescrOut
{
private:
    TTree   *pTreeOut;    // tree to open for output
    TBranch *pBranchOut;  // branch to open for output

public:
    MRootFileOut(const char *fName, const char *cname, MParContainer **obj);
    void SetAddress(MParContainer **obj);
    void Fill();
};

/* -------------------- Magic File --------------------- */

class MMagicFileIn : public MFileDescrIn
{
private:
    fstream *fin;
    MParContainer *fContainer;         // tree to open for input

public:
    MMagicFileIn(const char *fname);
    ~MMagicFileIn();

    void SetAddress(MParContainer **obj);
    void GetEvent(Int_t n=0);
};

class MMagicFileOut : public MFileDescrOut
{
private:
    fstream *fout;
    MParContainer *fContainer;

public:
    MMagicFileOut(const char *fname, MParContainer **obj);
    ~MMagicFileOut();

    void SetAddress(MParContainer **obj);
    void Fill();
};

#endif
