/////////////////////////////////////////////////////////////////
//
//  checkmc.h
//
//  Created: Thu May  7 16:24:22 1998
//  Authors:  Jose Carlos Gonzalez et al.
//  Purpose: include file for checkmc.cxx
//  Notes: version 2-10-98  
//  
/////////////////////////////////////////////////////////////////

// @T \newpage

// @section Source code of {\tt checkmc.h}

/* @text
This section shows the include file {\tt checkmc.h}
@endtext */

// @subsection Include files

// @code
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>
#include <float.h>
#include <sys/types.h>
#include <dirent.h>

#include "jcmacros.h"
#include "jcdebug.h"

#include "COREventHeader.hxx"
#include "CORParticle.hxx"
#include "CORStatfile.hxx"

// @endcode

// @subsection Macro-definitions, and constants

// @code



#ifndef VERSION 

#define PROGRAM checkmc
#define VERSION 1.0

#define GLUE_prep(x,y) #x" "#y
#define GLUE_postp(x,y) GLUE_prep(x,y)

const char SIGNATURE[] = GLUE_postp( PROGRAM, VERSION );

#endif // ! VERSION



#define NORM(x) (sqrt(SQR(x[0])+SQR(x[1])+SQR(x[2]))) /* Norm(vector) */
#define RAD(x)  ((x)*0.0174532925199433)
#define DEG(x)  ((x)*57.2957795130823)



// now we define the list PAR_ITEM_LIST of possible items in
// the CT definition file.

#define PAR_ITEM_LIST  /* LIST OF ITEMS IN THE CT DEFINITION FILE */  \
T(data_paths),      /* begin of the list of source data paths */   \
T(output_file),     /* output file */                              \
T(verbose_level),   /* defines verbose level of the output */      \
T(max_events),      /* maximum number of event to read */ \
T(reference_histo),     /* reference histogram  */                              \
T(end_file)         /* end of the parameters file */
 
#define T(x)  x             // define T() as the name as it is

enum PAR_ITEM_TYPE {
  PAR_ITEM_LIST
};

#undef T

#define T(x)  #x              // define T() as the string of x

const char *const PAR_ITEM_NAMES[] = {
  PAR_ITEM_LIST
};

#undef T


#define LINE_MAX_LENGTH  120
#define ITEM_MAX_LENGTH  40
#define PATH_MAX_LENGTH  120

#define NTHSTEP          79  // assumes thstep = 10 g/cm2    (790/10 = 79)

// maximum number of bins for the 1D histograms
#define NMAXBINS 100 


// Verbose Levels
enum VerboseLevel {
  VERBOSE_QUIET,
  VERBOSE_MINIMAL,
  VERBOSE_NORMAL,
  VERBOSE_MAXIMAL
};

#define VERBOSE_DEFAULT  VERBOSE_MINIMAL

// @endcode

/* @text
Definition of the dimensions of the diagnostics messages array in 
  monitor_event()
@endtext */
// @code
#define DIAGX 256
#define DIAGY 20
// @endcode


/* @text
Data for the atmosphere: useful for conversion between height and thickness.
@endtext */

// @code

float  AATM[5] = { 
  -186.5562e0,  
  -94.919e0,  
  0.61289e0,
  0.e0,
  .01128292e0 };
float  BATM[5] = { 
  1222.6562e0,
  1144.9069e0,
  1305.5948e0,
  540.1778e0,
  0.e0  };
float  CATM[5] = { 
  994186.38e0,
  878153.55e0,
  636143.04e0,
  772170.16e0,
  1.e-9};
float  DATM[5] = { 
   1.00584761581626e-06,
   1.13875301193054e-06,
   1.57197349828743e-06,
   1.29505133946124e-06,
   1.00000000000000e+09};   // = 1 / CATM

// @endcode


// @subsection Prototypes of functions

//++
// prototypes
//--

//@code

void present(void);
void log(const char *funct, char *fmt, ...);
void error(const char *funct, char *fmt, ...);
void readparam(void);
int get_num_of_paths(void);
char *get_path_name(int i);
char *get_output_filename(void);
int get_max_events(void);
float thick( float height, float theta );
float height( float thk, float theta );
void monitor_event(char diag[DIAGX][DIAGY], int *ndiag, const char* primary, 
                          const float a, const float b, const char* message); 

// @endcode

// @text
// CFortran routines will be used.
// @endtext

// @code
#include <stdlib.h>
#include <cfortran.h>
// #include <packlib.h>
#include "hbook.h"
//#include "minuit.h"
//#include "kuip.h"
//#include "zebra.h"

#define PAWC_SIZE 1000000

float pawc_[PAWC_SIZE];

// extern "C"
//{
//  extern void hlimit_(int*);
//  extern void hropen_(int*, char*, char*, char*, int*, int*, int, int, int);
//  extern void hbookn_(int*, char*, int*, char*, int*, char*, int, int, int);
//  extern void hrout_(int*, int*, char*, int);
//  extern void hrend_(char*, int);
//  extern void hfn_(int*, float*);
// }
// @endcode


  char* strconcat(const char* s1, const char* s2, char* s3)
  {
   for (int i=0;s3[i]=s1[i]; ++i); 
   for (int i=strlen(s1);s3[i]=s2[i-strlen(s1)]; ++i);
   return s3;
  }



