
#ifndef ROOT_RConfig
#define ROOT_RConfig

/*************************************************************************
 *                                                                       *
 * RConfig                                                               *
 *                                                                       *
 * Defines used by ROOT.                                                 *
 *                                                                       *
 *************************************************************************/

/*---- machines --------------------------------------------------------------*/

#ifdef __hpux
#   define R__HPUX
#   define R__UNIX
#   define ANSICPP
#endif

#ifdef _AIX
#   define R__AIX
#   define R__UNIX
#   define ANSICPP
#   define NEED_STRCASECMP
#endif

#ifdef __alpha
#   define R__ALPHA
#   define R__UNIX
#   define ANSICPP
#   define R__B64
#   define R__BYTESWAP
#endif

#ifdef __sun
#   ifdef __SVR4
#      define R__SOLARIS
#      define ANSICPP
#      ifdef __i386
#         define R__I386
#         define R__BYTESWAP
#      endif
#   else
#      define R__SUN
#      include <stdlib.h>
#   endif
#   define R__UNIX
#   define NEED_STRING
#   define NEED_SIGJMP
#endif

#ifdef __sgi
#   define R__SGI
#   define R__UNIX
#   define ANSICPP
#   define NEED_STRING
#   define NEED_SIGJMP
#   ifdef IRIX64
#     define R__SGI64
#   endif
#endif

#if defined(__linux) && !defined(__powerpc)
#   define R__LINUX
#   define R__UNIX
#   define R__BYTESWAP
#   define NEED_SIGJMP
#endif

#if defined(__linux) && defined(__powerpc)
#   define R__MKLINUX
#   define R__LINUX
#   define R__UNIX
#   define NEED_SIGJMP
#endif

#ifdef __GNUG__
#   define R__GNU
#   define ANSICPP
#endif

#ifdef BORLAND
#   define MSDOS        /* Windows will always stay MSDOS */
#   define ANSICPP
#   define R__INT16
#   define R__BYTESWAP
#endif

#ifdef __SC__
#   define SC
#   if defined(macintosh)
#      define R__MAC
#      define NEED_STRING
#      define ANSICPP
#   elif WIN32
#      define NEED_STRING
#      define NEED_STRCASECMP
#      define ANSICPP
#   else
#      define MSDOS
#      define NEED_STRCASECMP
#   endif
#endif

#ifdef WIN32
#   define NEED_STRING
#   define NEED_STRCASECMP
#   define ANSICPP
#   define R__BYTESWAP
#endif

#ifdef __MWERKS__
#   define R__MWERKS
#   define R__MAC
#   define ANSILIB      /* ANSI C++ Standard Library conformant */
#   define ANSICPP
#   define NEED_STRING
#   define NEED_STRCASECMP
#endif


/*--- memory and object statistics -------------------------------------------*/

/* #define NOSTATS     */


/*--- cpp --------------------------------------------------------------------*/

#ifdef ANSICPP
   /* symbol concatenation operator */
#   define _NAME1_(name) name
#   define _NAME2_(name1,name2) name1##name2
#   define _NAME3_(name1,name2,name3) name1##name2##name3

   /* stringizing */
#   define _QUOTE_(name) #name

#else

#   define _NAME1_(name) name
#   define _NAME2_(name1,name2) _NAME1_(name1)name2
#   define _NAME3_(name1,name2,name3) _NAME2_(name1,name2)name3

#   define _QUOTE_(name) "name"

#endif


/*---- misc ------------------------------------------------------------------*/

#ifdef R__GNU
#   define SafeDelete(p) { if (p) { delete p; p = 0; } }
#else
#   define SafeDelete(p) { delete p; p = 0; }
#endif

#endif

