<?php

function gettypename($type2)
{
    switch ($type2)
    {
    case "calib":
        $type="callisto";
        break;
    case "signal":
        $type="callisto";
        break;
    case "star":
        $type="star";
        break;
    }
    return $type;
}

function nexttype2($type2)
{
    switch ($type2)
    {
    case "calib":
        $type2="signal";
        break;
    case "signal":
        $type2="star";
        break;
    case "star":
        $type2="calib";
        break;
    }
    return $type2;
}

function getplotname($seq, $tabnum, $type, $type2)
{
    $seqlong=str_pad($seq, 8, "0", STR_PAD_LEFT);
    $seqshort=substr($seqlong, 0, 4);
    $plot  = "http://vela.astro.uni-wuerzburg.de/datacenter/";
    $plot .= $type . "/" . str_pad( $seqshort, 4, "0", STR_PAD_LEFT);
    $plot .= "/" . $seqlong . "/" . $type2 . $seqlong . "-tab" . $tabnum . ".png";
    return $plot;
}

printf("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
printf("<html>\n<head>\n");
printf("<meta http-equiv='content-type' content='text/html; charset=ISO-8859-1'>\n");
printf("<title>show plots</title>\n");
printf("<link rel='stylesheet' type='text/css' href='lamouette.css'>\n");
printf("</head>\n");
printf("<body>\n");

$seq=0;
if (!empty($_GET["seq"]))
    $seq=$_GET["seq"];
$tabnum=1;
if (!empty($_GET["tabnum"]))
    $tabnum=$_GET["tabnum"];
$type2="calib";
if (!empty($_GET["type2"]))
    $type2=$_GET["type2"];

if (!empty($seq))
{
    $type=gettypename($type2);
    $plot=getplotname($seq, $tabnum, $type, $type2);

    //be careful: this has to be adapted in case tabs are removed or new tabs are added
    if (($type2=="calib" && $tabnum==12) || ($type2=="signal" && $tabnum==11) || ($type2=="star" && $tabnum==15))
    {
        $tabnum=1;
        $type2=nexttype2($type2);
        $type=gettypename($type2);
        $plot=getplotname($seq, $tabnum, $type, $type2);
    }
    $tabnum=$tabnum+1;
}
printf("<form action='showplots.php' method='GET'>\n");
printf("<table width='100%%' border='0'>\n");
printf("<tr><td>\n");
printf("<input type='text' name='seq' size='10' maxlength='10' value='%s'>\n", $seq);
printf("<input type='text' name='type2' size='10' maxlength='10' value='%s'>\n", $type2);
printf("<input type='text' name='tabnum' size='2' maxlenght='2' value='%s'>\n", $tabnum);
printf("<input type='submit' value='Show Plot'>\n");
printf("plot: %s<br>", $plot);
printf("</td>\n</tr>\n<tr>\n<td>\n");
if (!empty($seq))
    printf("<img src='%s'>", $plot);
else
    printf("You have to select a sequence.");
printf("</td>\n</tr>\n</table>\n");
printf("</form>\n");
printf("</body>\n");
printf("</html>\n");

?>
