#ifndef COSY_MGNumStars
#define COSY_MGNumStars

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)

#ifndef COSY_MGEmbeddedCanvas
#include "MGEmbeddedCanvas.h"
#endif

class TGraph;
class TLine;
class TText;

class ZdAz;

class MGNumStars : public MGEmbeddedCanvas
{
protected:
    TLine  *fLin1;
    TLine  *fLin2;

    TText  *fTxt;

    TLine  *fBar1;
    TLine  *fBar2;

    TGraph *fGraph1;
    TGraph *fGraph2;

    Double_t fTime;

    void DrawCoordinateSystem();

    void InitText();
    void InitCross();
    void InitBar(TLine* &bar);
    void InitGraph(TGraph* &graph, Int_t col);

    void UpdateBar(TLine &bar, UInt_t num);
    void UpdateGraph(TGraph &graph, Double_t dtime, UInt_t num);

public:
    MGNumStars(const TGWindow* p, const UInt_t w);
    ~MGNumStars();

    void DrawText(const char *txt);

    void Update(UInt_t det, UInt_t cor);

    ClassDef(MGNumStars, 0)
};

#endif // COSY_MGNumStars
