#include "MCosy.h"

#include <iomanip.h>
#include <fstream.h>
#include <iostream.h>

#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h>

#include "MGCosy.h"

#include "macs.h"
#include "timer.h"
#include "slalib.h"
#include "slamac.h"
#include "shaftencoder.h"

#include <sys/resource.h>  // PRIO_PROCESS

int main(int argc, char **argv)
{
    //
    // this must move to MGCosy !!!! (or MApplication)
    //
    ofstream lout("cosy.log");
    lout << "Starting Cosy" << endl;

    //
    // start the main window
    //
    lout << "- Initialising Root environment." << endl;
    TROOT root("Cosy", "Magic Control System");
    TApplication app ("App", &argc, argv);

    //
    // Create the Network. Device: /dev/dpm_00, Rate: 500kbps
    //
    MCosy *cosy = new MCosy("/dev/dpm_00", 500, lout);
    cosy->Start();

    lout << "- Starting mailoop." << endl;
    app.Run();

    cosy->Stop();

    delete cosy;

    lout << "- Terminating Program." << endl;
    cout << "The End." << endl;
}
