/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MMars.h"

#include <TApplication.h>  // gROOT->GetApplication()->...

#include <TGTab.h>         // TGTab
#include <TGMenu.h>        // TGPopupMenu
#include <TGMsgBox.h>      // TGMsgBox
#include <TGButton.h>      // TGPictureButton
#include <TGSplitter.h>    // TGHorizontal3DLine

#include "MEvtDisp.h"
#include "MDataCheck.h"
#include "MMonteCarlo.h"

#include "MGPrototyp.h"

ClassImp(MMars)

enum {
  M_FILE_EXIT  ,
  M_FILE_ABOUT  ,

  M_PICTURE_MAGIC , 
  M_PICTURE_MARS ,

  M_BUTTON_EVTDISP ,
  M_BUTTON_DATACHECK ,
  M_BUTTON_ANALYSE ,
  M_BUTTON_MONTECARLO 
} ; 


MMars::MMars(/*const TGWindow *p,*/ UInt_t w, UInt_t h)
  : TGMainFrame(gClient->GetRoot(), w, h)
{ 
  //    First create the MenuBar.   
  
  //     Layout objects for menue. 

  fLayMenuBar = new TGLayoutHints ( kLHintsTop | kLHintsLeft | kLHintsExpandX, 2, 2, 2, 2 ) ; 
  fLayMenuItem = new TGLayoutHints ( kLHintsTop | kLHintsLeft , 0, 4, 0, 0 ) ; 
  
  //  crate the menu bar
  
  fFileMenu = new TGPopupMenu ( fClient->GetRoot() ) ; 
  fFileMenu->AddEntry ("Exit", M_FILE_EXIT ) ; 
  fFileMenu->Associate(this) ; 
  
  //  the button messages are handled by main frame (this) 
  
  fMenuBar = new TGMenuBar ( this, 1, 1, kHorizontalFrame ) ; 
  fMenuBar->AddPopup("File", fFileMenu, fLayMenuItem ) ;   
  AddFrame(fMenuBar, fLayMenuBar ) ; 

  fLineSep = new TGHorizontal3DLine(this) ; 
  AddFrame(fLineSep, new TGLayoutHints(kLHintsTop | kLHintsExpandX) );
  
  //   set up the top part of the main window with the logos

  fTop = new TGHorizontalFrame (this, 300, 100 ) ;

  fPicMagic = new TGPictureButton(fTop, 
                                  gClient->GetPicture("magiclogo.xpm"), M_PICTURE_MAGIC );
  fPicMagic->Associate(this) ; 
  fTop->AddFrame ( fPicMagic, new TGLayoutHints(kLHintsLeft, 10., 10., 20., 10.) ) ; 

  fPicMars = new TGPictureButton(fTop, 
				 gClient->GetPicture("marslogo.xpm"), M_PICTURE_MARS );
  fPicMars->Associate(this) ;
  fTop->AddFrame ( fPicMars, new TGLayoutHints(kLHintsLeft, 10., 10., 10., 10.) ) ; 

  AddFrame(fTop, new TGLayoutHints(kLHintsTop | kLHintsExpandX ) );  
  
  //  a seperator 

  fLineSep2 = new TGHorizontal3DLine(this) ; 
  AddFrame(fLineSep2, new TGLayoutHints(kLHintsTop | kLHintsExpandX) );

  //   the low part of the frame 

  fLow = new TGHorizontalFrame (this, 300, 100 ) ;

  //    create the first tab

  fTab = new TGTab ( fLow, 400, 400 ) ;   

  TGCompositeFrame *tf = fTab->AddTab("Control") ; 
 
  fTabF1 = new TGVerticalFrame (tf, 300, 100) ; 

  tf->AddFrame(fTabF1, new TGLayoutHints(kLHintsTop | kLHintsExpandX) ) ; 

  //     the buttons to go in the new window

  fTabF2 = new TGVerticalFrame (tf, 300, 100) ; 
  
  fButLayout  = new TGLayoutHints(kLHintsTop | kLHintsCenterX , 10, 10, 10, 10) ; 

  fButEvtDisp = new TGTextButton(fTabF2, "EventDisplay", M_BUTTON_EVTDISP  );
  fButEvtDisp->Associate(this) ;  
  fTabF2->AddFrame(fButEvtDisp, fButLayout ) ; 
 
  fButDataCheck = new TGTextButton(fTabF2, "Data Check", M_BUTTON_DATACHECK  );
  fButDataCheck->Associate(this) ;
  fTabF2->AddFrame(fButDataCheck, fButLayout ) ; 

  fButAnalys = new TGTextButton(fTabF2, "Analysis", M_BUTTON_ANALYSE  );
  fButAnalys->Associate(this) ;
  fTabF2->AddFrame(fButAnalys, fButLayout ) ; 

  fButMonteCarlo = new TGTextButton(fTabF2, "MonteCarlo", M_BUTTON_MONTECARLO  );
  fButMonteCarlo->Associate(this) ;
  fTabF2->AddFrame(fButMonteCarlo, fButLayout ) ; 


   

  tf->AddFrame(fTabF2, new TGLayoutHints(kLHintsTop | kLHintsExpandX) ) ; 
  
  

  fLow->AddFrame ( fTab, new TGLayoutHints(kLHintsBottom | kLHintsExpandX | kLHintsExpandY, 5, 5, 5, 5) );   
  AddFrame(fLow, new TGLayoutHints(kLHintsTop | kLHintsExpandX ) );
  
  //   Map the window, set up the layout, etc. 
  
  SetWMSizeHints(400, 650, 1000, 1000, 10, 10 ) ;  // set the smallest and biggest size of the Main frame
  
  MapSubwindows();
  
  Layout();
  
  SetWindowName("MARS Main Window");
  SetIconName("MARS");
  
  MapWindow();

} 

// ======================================================================

MMars::~MMars()
{
  
    delete fButLayout;
    delete fLayMenuBar;
    delete fLayMenuItem;
    delete fButEvtDisp;
    delete fButDataCheck;
    delete fButAnalys;
    delete fButMonteCarlo;
    delete fPicMagic;
    delete fPicMars;
    delete fTabF1;
    delete fTabF2;
    delete fTab;
    delete fLow;
    delete fTop;
    delete fLineSep2;
    delete fLineSep;
    delete fFileMenu;
    delete fMenuBar;
}  
// ======================================================================

void MMars::CloseWindow()
{
   // Got close message for this MainFrame. Calls parent CloseWindow()
   // (which destroys the window) and terminate the application.
   // The close message is generated by the window manager when its close
   // window menu item is selected.

   TGMainFrame::CloseWindow();
   gROOT->GetApplication()->Terminate(0)  ; 
}

void MMars::DisplWarning(const char *txt)
{
    Int_t retval;
    new TGMsgBox(fClient->GetRoot(), this,
                 "WARNING!", txt,
                 kMBIconExclamation, 4, &retval);
}

Bool_t MMars::ProcessMessage(Long_t msg, Long_t parm1, Long_t)
{     
    // Process events generated by the buttons in the frame.

    switch (GET_MSG(msg))
    {
    case kC_COMMAND:
        switch (GET_SUBMSG(msg))
        {
        case kCM_BUTTON:

            switch (parm1)
            {

            case M_BUTTON_EVTDISP:
                new MEvtDisp(this);
                return kTRUE;

            case M_BUTTON_DATACHECK:
                new MDataCheck(this);
                return kTRUE;

            case M_BUTTON_ANALYSE:
                DisplWarning("Analysis not yet implemented!");
                return kTRUE;

            case M_BUTTON_MONTECARLO:
                new MMonteCarlo(this);
                return kTRUE;

            case M_PICTURE_MAGIC:
                DisplWarning("Please open a Netscape to the MAGIC homepage");
                return kTRUE;

            case M_PICTURE_MARS:
                DisplWarning("Please open a Netscape to the MARS homepage");
                return kTRUE;

            }

	case kCM_MENU:
            if (parm1!=M_FILE_EXIT)
                return kTRUE;

            CloseWindow() ;
            return kTRUE;
	}
    }

    return kTRUE;
}
