/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lopez (jlopez@ifae.es)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MMcEnerThre                                                             //
//                                                                         //
// Hold the energy threshold information for the different trigger         //
// conditions                                                              //
//                                                                         // 
/////////////////////////////////////////////////////////////////////////////
#include "MMcEnerThre.h"

#include "MLog.h"

ClassImp(MMcEnerThre)

MMcEnerThre::MMcEnerThre(const int dim,
			 const char *name, const char *title) : fNumTrigCond(1)
{ 
  //
  //   default constructor
  //

  *fName  = name  ? name  : "MMcEnerThre";
  *fTitle = title ? title : "Storage container for Energy Threshold informantion for the different trigger conditions";
  
  fNumTrigCond = dim;

  fArray = new TClonesArray("MMcEnerHisto",fNumTrigCond);

  //
  // TClonesArray: The 'new operator with placement' must be used
  //
  for (int i=0; i<fNumTrigCond; i++)
    new ((*fArray)[i]) MMcEnerHisto(i);

} 

MMcEnerThre::~MMcEnerThre()
{
    // FIXME: Do we have to delete the objects itself?
    delete fArray;
}
