void getThreshold( char* filename = "/hdb1/users/jlopez/temp_loop.root")
{
    // This macro fill the container MMcEnerThre using the task
    // MMcEnerThreCalc and shows the results.

    MParList parlist;
    MTaskList tasklist;

    // Setup the parameter list
    // - You need create the container MMcEnerThre.
    //    + You need to put the number of trigger conditions when
    //      you declarete the MMcEnerThre
    //    + If you don't put any dimension to MMcEnerThre it works
    //      taking only the trigger information from MMcTrig
    // - You can control the number of bins in the energy distribution
    //   histogram used to compute the energy threshold using
    //   the SetBins() function.

    Int_t numtrigcond = 5;
    MHMcEnergies *hists = new MHMcEnergies(numtrigcond);

    parlist.AddToList(&tasklist);
    hists->AddEntriesToList(&parlist);

    // Setup the task list
    // - You need the read and the MMcEnerThreCalc tasks
    //    + You need to put the number of trigger conditions when
    //      you declarete the MMcEnerThreCalc
    //    + If you don't put any dimension to MMcEnerThreCalc it works
    //      like one dimension MMcEnerThreCalc

    MReadTree read("Events", filename);

    MMcThresholdCalc tcalc(numtrigcond);

    tasklist.AddToList(&read);
    tasklist.AddToList(&tcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&parlist);

    // Begin the loop

    evtloop.Eventloop();

    // Now you can display the results

    TCanvas *c;

    c=new TCanvas("c0","Energy distribution for triggered events", 50, 50, 850, 550);
    hists[0].Print();
    hists[0].Draw();
    c->Update();

    c= new TCanvas("c1","Energy distribution for triggered events", 50, 50, 850, 550);
    hists[1].Print();
    hists[1].Draw();
    c->Update();

    c= new TCanvas("c2","Energy distribution for triggered events", 50, 50, 850, 550);
    hists[2].Print();
    hists[2].Draw();
    c->Update();

    c= new TCanvas("c3","Energy distribution for triggered events", 50, 50, 850, 550);
    hists[3].Print();
    hists[3].Draw();
    c->Update();

    c= new TCanvas("c4","Energy distribution for triggered events", 50, 50, 850, 550);
    hists[4].Print();
    hists[4].Draw();
    c->Update();
}
