/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

////////////////////////////////////////////////////////////////////////
//
//  MFillHStarMap
//
//  This task fills a star map (a 2D histogram, MHStarMap)
//  from the calculated hillas parameter (MHillas).
//  The algorithm for this can be found in MHStarMap::Fill
//
////////////////////////////////////////////////////////////////////////
#include "MFillHStarMap.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MHStarMap.h"
#include "MHillas.h"
#include "MParList.h"

ClassImp(MFillHStarMap)

// --------------------------------------------------------------------------
MFillHStarMap::MFillHStarMap (const char *name, const char *title)
{
    *fName  = name  ? name  : "MFillHStarMap";
    *fTitle = title ? title : "Task to fill a StarMap";
}

// --------------------------------------------------------------------------
Bool_t MFillHStarMap::PreProcess (MParList *pList)
{
    fEvt = (MHillas*)pList->FindObject("MHillas");
    if (!fEvt)
    {
        *fLog << dbginf << "MHillas not found... aborting." << endl;
        return kFALSE ;
    }

    fHistos = (MHStarMap*)pList->FindCreateObj("MHStarMap");
    if (!fHistos)
        return kFALSE;

    return kTRUE ;
} 

// --------------------------------------------------------------------------
Bool_t MFillHStarMap::Process()
{
    fHistos->Fill(fEvt);

    return kTRUE;
} 

Bool_t MFillHStarMap::PostProcess()
{
    fHistos->SetHasChanged();

    return kTRUE;
} 
