#ifndef MMCENERTHRECALC_H
#define MMCENERTHRECALC_H 

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MMcEnerThreCalc                                                           //
//                                                                         //
// Compute the energy threshold from Monte Carlo data                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MTASK_h
#include "MTask.h"
#endif

class MMcEvt;
class MMcTrig;
class MMcEnerThre;

class MMcEnerThreCalc : public MTask
{
 private:

  MMcEvt* fMMcEvt;            // Container with Monte Carlo information
  MMcTrig** fMMcTrig;         // Container with Monte Carlo trigger information
  MMcEnerThre* fMMcEnerThre;  // Container where we save the energy threshold
                              // information
  Int_t fDimension;

 public:

  MMcEnerThreCalc ( const int dim = 0,
		    const char* name = NULL, const char* title = NULL);

  Bool_t PreProcess(MParList* pList);
  Bool_t Process();
  Bool_t PostProcess();

  ClassDef(MMcEnerThreCalc, 0) // Task to fill the energy threshold information 
};

#endif



