/***************************************************************************
                          amcerrors.h  -  description
                             -------------------
    begin                : Sun Nov 24 2002
    copyright            : (C) 2002 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is part of the MAGIC control software for the AMC.       *
 *   The software is only intended for use in the MAGIC telescope project  *
 *   All rights remain with the author.					   *
 ***************************************************************************/

// Definitions serial port errors
// the AMC due to problems sending commands
#define IDS_ERROR_PORT_OPEN					"Can't open serial device"
#define IDS_ERROR_PORT_GET_ATTR				"Can't get TERMIO data structre from serial port"
#define IDS_ERROR_PORT_SET_ATTR				"Can't set TERMIO data structre for serial port"


// Definitions of errors and warnings send by
// the AMC contorller
#define IDS_ERROR_NOERROR					"No error!"
#define IDS_ERROR_UNKNOWN					"Unknown AMC error!"
#define IDS_ERROR_SPI_OVERFLOW				"Overflow of SPI buffer!"
#define IDS_ERROR_SPI_WTIMEOUT				"SPI write timeout!"
#define IDS_ERROR_SPI_RTIMEOUT				"SPI read timeout!"
#define IDS_ERROR_BAD_ARGUMENT				"Bad argument in AMC command!"
#define IDS_ERROR_NO_DRIVER					"AMC command send with no driver selected!"
#define IDS_ERROR_BAD_DRIVER				"AMC command to select a driver with wrong driver number!"
#define IDS_ERROR_TEMP_RANGE				"Temperature information from AMC box is out of range!"
#define IDS_ERROR_HUMIDITY_RANGE			"Humidity information from AMC box is out of range!"
#define IDS_ERROR_I_POWER_RANGE				"Power supply current information from AMC box is out of range!"
#define IDS_ERROR_V_POWER_RANGE				"Power supply voltage information from AMC box is out of range!"
#define IDS_ERROR_V_SECONDARY_RANGE			"Secondary supply voltage information from AMC box is out of range!"
#define IDS_ERROR_V_LOGICAL_RANGE			"Logical supply voltage information from AMC box is out of range!"


// Definitions of errors and warnings send by
// the AMC due to problems sending commands
#define IDS_ERROR_NO_RESPONSE				"AMC controller didn't respond to command"
#define IDS_ERROR_NO_AMC_STATUS				"AMC controller didn't respond with an allowed status. We may have lost part of the response"
#define IDS_ERROR_MOVEMENT_TIMEOUT			"The motor movement didn't complete in the expected time. We killed the movement and reseted the driver."
#define IDS_WARNING_WRONG_TUNING			"Attention!!! The settings are not valid. They will be resetted to the default values now!"


// Definitions of errors and warnings generated
// when laser adjusting the mirror
#define IDS_ERROR_NO_SPOT				"No video spot found"
#define IDS_ERROR_MULTI_SPOT				"Multiple video spot found"
#define IDS_ERROR_NO_CONVERGENCE				"Laser adjustment didn't converge"

