#ifndef FILE_H
#define FILE_H

#include <stdio.h>

class File
{
private:
    FILE *f;

public:
    File(const char *name, const char *flags);
    ~File();

    void Reset() const;
    int  Eof() const;

    void Seek(long pos) const;
    long Tell() const;
    long Size() const;

    char  Getc() const;
    char *Gets(char *c, int cnt) const;
    int   Geti(int cnt) const;
    float Getf(int cnt) const;

    void Newline() const;
    void Skip(int cnt) const;

    int operator!() { return !f; }
};

#endif
