#ifndef MHILLASCALC_H
#define MHILLASCALC_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MHillasCalkc                                                            //
//                                                                         //
// Task to calculate Hillas Parameters                                     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MTASK_H
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;

class MHillasCalc : public MTask
{
    MGeomCam    *fGeomCam;    // Camera Geometry used to calculate Hillas
    MCerPhotEvt *fCerPhotEvt; // Cerenkov Photon Event used for calculation
    MHillas     *fHillas;     // ouput container to store result

public:
    MHillasCalc(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MHillasCalc, 0)   // Task to calculate Hillas parameters
};

#endif
