#ifndef MMCPEDESTALCOPY_H
#define MMCPEDESTALCOPY_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MMcPedestalCopy                                                         //
//                                                                         //
// This task copies the pedestals from the MC data into the corresponding  //
// MARS Container (MPedestals). This seems to be overdone, but at this     //
// point you have a standard interface to access the pedestals             //
// (MPedestals), which makes it possible that from now on all pedestals    //
// can be treated in the same way                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MTASK_H
#include "MTask.h"
#endif

class MMcFadcHeader;
class MPedestalCam;

class MMcPedestalCopy : public MTask
{
    MMcFadcHeader *fMcPedestals;  //
    MPedestalCam  *fPedestals;    //

    TString       *fSrc;

public:
    MMcPedestalCopy(const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MMcPedestalCopy, 0)   // Task which copies the pedestals from the MC into the standard container
};

#endif
