/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MGeomCam.h"

#include "MLog.h"
#include "MHexagon.h"

ClassImp(MGeomCam)

MGeomCam::MGeomCam(UInt_t npix, const char *name, const char *title)
{
    *fName  = name  ? name  : "MGeomCam";
    *fTitle = title ? title : "Storage container for  a camera geometry";

    fNumPixels = npix;
    fPixels    = new TObjArray(npix);

    //
    // make sure that the destructor delete all contained objects
    //
    fPixels->SetOwner();

    for (UInt_t i=0; i<npix; i++)
        (*fPixels)[i] = new MGeomPix;
}

void MGeomCam::Draw( Option_t * )
{
    //
    // Draw the Camera
    //
    for (UInt_t i=0; i<fNumPixels; i++)
    {
        MHexagon *el = new MHexagon((*this)[i]);
        el->Draw();
    }
}

void MGeomCam::Print(Option_t *)
{
    //
    //   Print Information about the Geometry of the camera
    //
    *fLog << " Number of Pixels: " << fNumPixels << endl ;

    for (UInt_t i=0; i<fNumPixels; i++ )
    {
        *fLog << " Pixel: " << i << "  ";
        (*this)[i].Print() ;
    }
} 

