#ifndef MGEOMCAM_H
#define MGEOMCAM_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif
#ifndef MGEOMPIX_H
#include "MGeomPix.h"
#endif

class MGeomCam : public MParContainer
{
private:
    UInt_t     fNumPixels;  // Number of pixels in this camera
    TObjArray *fPixels;     // Array of singel pixels storing the geometry

public:

    MGeomCam(UInt_t npix, const char *name=NULL, const char *title=NULL);

    virtual ~MGeomCam() { delete fPixels; }

    virtual void Draw(Option_t *option = "" );

    UInt_t GetNumPixels() const { return fNumPixels; }

    MGeomPix &operator[](Int_t i) { return *(MGeomPix*)fPixels->At(i); }

    virtual void Print(Option_t *opt=NULL);

    ClassDef(MGeomCam, 1)		// Geometry base class for the camera
};

#endif

