/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Javier Lopez 05/2001 (jlopez@ifae.es)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MHMcEnergies.h" 

#include "MParList.h"
#include "MHMcEnergy.h"

ClassImp(MHMcEnergies)

MHMcEnergies::MHMcEnergies(const UInt_t count, const char *name, const char *title)
    : fNum(count)
{ 
    //
    //   default constructor
    //
    char aux[25]="MHMcEnergies";
    sprintf(aux+12, "[%i]", fNum);

    *fName  = name  ? name  : aux;
    *fTitle = title ? title : "Container for a MC enegry histogram" ;

    fHists = new TClonesArray("MHMcEnergy", fNum);

    for (UInt_t i=0; i<fNum; i++)
        new ((*fHists)[i]) MHMcEnergy(i);
}

MHMcEnergies::~MHMcEnergies()
{
    delete fHists;
}

void MHMcEnergies::AddEntriesToList(MParList *plist)
{
    for (UInt_t i=0; i<fNum; i++)
        plist->AddToList((MParContainer*)(*fHists)[i]);
}
