#ifndef MMCENERTHRE_H
#define MMCENERTHRE_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

#ifndef MMCENERHISTO_H
#include <MMcEnerHisto.h>
#endif

#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif


class MMcEnerThre : public MParContainer { 

 private: 

  TClonesArray* fArray; // Array of MMcEnerHisto elements
  Int_t fNumTrigCond;   // dimension of the fArray

 public: 
  
  MMcEnerThre(const int dim = 1,
	      const char *name=NULL, const char *title=NULL) ; 

  ~MMcEnerThre() ; 

  Int_t GetNumTrigCond() {return fNumTrigCond;}

  // To access to the MMcEnerHisto functions from MMcEnerThre we overload
  // the operator []
  MMcEnerHisto* operator[](Int_t index) {return (MMcEnerHisto*)fArray->At(index);}

  ClassDef(MMcEnerThre, 1)  //  Data Container to calculate Energy Threshold
} ; 

#endif 
