/***************************************************************************
                          heatstate.cpp  -  description
                             -------------------
    begin                : Sat Aug 23 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "heatstate.h"

HEATState::HEATState(QWidget *parent, const char *name ) : QWidget(parent,name)
{
	m_qsStateTxtTable[HEAT_STATE_ERROR]         = new QString( "Heating error" );
	m_qsStateTxtTable[HEAT_STATE_ON]            = new QString( "Heating is on" );
	m_qsStateTxtTable[HEAT_STATE_OFF]           = new QString( "Heating is off" );
	m_qsStateTxtTable[HEAT_STATE_DEICING]       = new QString( "Deicinng" );
	m_qsStateTxtTable[HEAT_STATE_NOT_AVAILABLE] = new QString( "Heating has no connection to CC" );
	m_qsStateTxtTable[HEAT_STATE_UNKNOWN]		    = new QString( "Heating is in an unknown state." );
}

HEATState::~HEATState(){
}

/** Set the state. */
void HEATState::setState( int p_iState )
{
  // if the new state is equal to the actual state we
  // do nothing.
	if( p_iState == m_iState )
		return;

	int iOldState = m_iState;
	m_iState = p_iState;

	emit stateChanged( iOldState, m_iState );
}

/** Return the actual state. */
int HEATState::getState() const
{
	return m_iState;
}

/** Get a textual description of the state. */
const QString& HEATState::getText( int p_iState ) const
{
	if ( ( p_iState < HEAT_STATE_ERROR )
				||
			 ( p_iState > HEAT_STATE_NOT_AVAILABLE ) )
		return( *m_qsStateTxtTable[ HEAT_STATE_UNKNOWN ] );
	else
		return( *m_qsStateTxtTable[ p_iState ] );
}
