#ifndef COSY_SdoList
#define COSY_SdoList

#ifdef __CINT__
typedef Byte_t   BYTE_t;
typedef UShort_t WORD_t;
#else
#include <TROOT.h>
#include "gendef.h"
#endif

#ifndef ROOT_TMutex
#include <TMutex.h>
#endif

class PendingSDO
{
public:
    BYTE_t Node;
    WORD_t Idx;
    BYTE_t Subidx;
    PendingSDO *Next;

    PendingSDO(BYTE_t n=0, WORD_t i=0, BYTE_t s=0)
        : Node(n), Idx(i), Subidx(s), Next(NULL) {}

    ClassDef(PendingSDO, 0)
};

class PendingSDOList
{
private:
    PendingSDO *fFirst;
    PendingSDO *fLast;

    TMutex fMux;

public:
    PendingSDOList();
    virtual ~PendingSDOList();

    void Add(BYTE_t node, WORD_t idx, BYTE_t subidx);
    void Del(BYTE_t node, WORD_t idx, BYTE_t subidx);
    void DelAll();

    int IsPending() const;
    int IsPending(BYTE_t node);
    int IsPending(BYTE_t node, WORD_t idx, BYTE_t subidx);

    ClassDef(PendingSDOList, 0)
};

#endif
