void MAGIC_sensitivity(void)
{
  float x[13] ={0.0462, 0.0572, 0.0705, 0.1204, 0.154, 0.1874, 0.2256, 0.2325, 0.3025, 0.3865, 0.4509, 0.5009, 0.5992};
  float ex[13];// ={0.064., 0.066., 0.080., 0.102., 0.356., 0.653.};
  float y[13] = {9.32,6.31,4.37,1.52,0.797,0.528,0.374,0.327,0.200,0.136,0.104,0.085,0.07};
  float ey[13];  //= {0.06e-8, 0.22e-9, 0.08e-9, 0.19e-10, 0.28e-11, 1.19e-13, 0.03};

  for (int i=0; i<13; i++){
    ex[i]=0.01*x[i];
    y[i]*=1e-11;
    ey[i]=0.01*y[i];
  }


  TGraphErrors * gr = new TGraphErrors(13,x,y,ex,ey);
  gr->SetMinimum(1e-9);
  gr->SetMinimum(1e-15);

  TF1 * f =new TF1("f","[0]*pow(x,[1])",0.0200,3.000);
  f->SetParameter(0,2e-13);
  f->SetParameter(1,-2.);

  // f->SetParameter(1,-4.4);

  TCanvas * cc = new TCanvas("cc","cc",600,400);
  cc->SetGridx();
  cc->SetGridy();
  cc->SetLogx();
  cc->SetLogy();


  gr->Draw("AP");
  gr->Fit(f,"RLM","");
  f->Draw("same");
}
