#ifndef MRAWPIXEL_H
#define MRAWPIXEL_H

#include "Magic.h"

#include "TObject.h"

class MRawPixel : public TObject
{
private:
    UShort_t PixelId;		//  Identification of PixelNumber and gain branch
    UChar_t PixelStatus;	//  The Status of the pixel
    UChar_t Fadc[kFADC_SLICES];	// The values of fadc-slices.

public:
     MRawPixel();
     MRawPixel(UShort_t);
     MRawPixel(UShort_t, UChar_t, UChar_t *);

    ~MRawPixel();

    void Clear(Option_t * t = NULL);
    void Print(Option_t * t = NULL);

    UShort_t GetPixelId();
    UChar_t *GetPixelData();
    UChar_t GetFadcSlice(Int_t);

    ClassDef(MRawPixel, 1)
};				// end of class definition of MRawPixel 

#endif
