
Int_t fBending(Int_t zd)
{
    return zd-1592;
}

Int_t GetSePos(Int_t p0, Int_t p1)
{
    return (p0-p1)/2;
}

void analse()
{
    TH2F hist1("Diff", "Difference of SE values", 201, -90, 110, 25, -12, 12);
    hist1.SetXTitle("ZA [\\circ]");
    hist1.SetYTitle("\\Delta SE");

    // ifstream fin("log/shaftencoder_slow_singleside.log");
    //ifstream fin("log/shaftencoder_fast.log");
    ifstream fin("log/shaftencoder.log");

    Int_t offset = 999999;

    Int_t turn[2], pos[2]={999999, 999999};
    while (!fin.eof())
    {
        Int_t id;
        fin >> id;

        fin >> turn[id-4] >> pos[id-4];

        if (offset==999999 && pos[0]!=999999 && pos[1]!=999999)
            offset = pos[1]+pos[0];

        if (offset==999999)
            continue;

        hist1.Fill(fBending(GetSePos(pos[0], pos[1]))*360/16384,
                   pos[0]+pos[1]-offset);
    }

    TCanvas *c=new TCanvas("c1", "", 1000, 1000);
    c->Divide(1,2);

    c->cd(1);
    TH2 *h=hist1.DrawCopy();

    TProfile *p = h->ProfileX("_pfx", -1, 9999, "s");
    p->SetLineColor(kBlue);
    p->Draw("same");
    p->SetBit(kCanDelete);

    c->cd(2);
    TH1F p2("spread", "Spread of the differences", hist1.GetNbinsX(), hist1.GetBinLowEdge(1),
            hist1.GetBinLowEdge(hist1.GetNbinsX()+1));
    p2.SetXTitle("ZA [\\circ]");
    for (int i=0; i<hist1.GetNbinsX(); i++)
        p2.SetBinError(i, p->GetBinError(i));
    p2.SetLineColor(kRed);
    p2.SetStats(0);
    p2.DrawCopy();
}
