#ifndef MARS_MGeomCamDwqarf
#define MARS_MGeomCamDwarf

#ifndef MARS_MGeomCam
#include "MGeomCam.h"
#endif

class MGeomCamDwarf : public MGeomCam
{
private:
    enum { kDirCenter, kDirNE, kDirN, kDirNW, kDirSW, kDirS, kDirSE };

    static Double_t CalcXY(Int_t dir, Int_t ring, Int_t i, Double_t &x, Double_t &y);

    static Int_t    CalcNumPix(Double_t rad);
    static Int_t    CalcNumPix(Int_t rings);

    void  CreateCam(Double_t diameter, Double_t rad);
    void  CreateCam(Double_t diameter, Int_t rings);
    void  CreateNN();

public:
    MGeomCamDwarf(Double_t rad, Double_t diameter=21, Double_t dist=4.92, const char *name=NULL);
    MGeomCamDwarf(Int_t  rings, Double_t diameter=21, Double_t dist=4.92, const char *name=NULL);
    MGeomCamDwarf(const char *name=NULL);

    TObject *Clone(const char *newname) const;

    ClassDef(MGeomCamDwarf, 1)		// Geometry class for the Dwarf camera
};

#endif

