#ifndef MARS_MReadRflFile
#define MARS_MReadRflFile

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

#ifndef MARS_MRead
#include "MRead.h"
#endif

class MZlib;
class TList;
class MRflEvtData;
class MRflEvtHeader;
class MRflRunHeader;

class MReadRflFile : public MRead
{
private:
    enum {
        kError,
        kEndOfFile,
        kStartOfRun,
        kEndOfRun,
        kStartOfEvtData,
        kEndOfEvtData,
        kUndefined
    };

    MZlib *fIn;              // the inputfile
    TList *fFileNames;       // Array which stores the \0-terminated filenames

    MRflEvtData   *fEvtData;    //!
    MRflEvtHeader *fEvtHeader;  //!
    MRflRunHeader *fRunHeader;  //!

    UInt_t  fNumFile;
    UInt_t  fEntries;           // TO BE IMPLEMENTED
    TString fFileName;

    Float_t fCurrentVersion;    //! Version of currently open rfl file

    float  ReadVersion();
    Bool_t ReadEvtHeader();
    Bool_t ReadEvtData();
    int    ReadFlag();
    Bool_t FlagIsA(const  char *s1, const char *flag);
    Int_t  EvalFlag();
    Bool_t OpenNextFile();

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MReadRflFile(const char *filename=NULL,
                 const char *name=NULL,
                 const char *title=NULL);

    ~MReadRflFile();

    Int_t AddFile(const char *fname, int i=0);

    Bool_t Rewind() { fNumFile=0; return kTRUE; }
    UInt_t GetEntries() { return fEntries; }
    TString GetFullFileName() const { return fFileName; }

    Bool_t SearchFor(Int_t runno, Int_t eventno);

    ClassDef(MReadRflFile, 0) // Reads reflector files
};

#endif
