#ifndef COSY_MTcpIpIO
#define COSY_MTcpIpIO

#ifndef MARS_MThread
#include "MThread.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif


class TString;
class TSocket;
class TServerSocket;

// A generalized class for receiving over tcp/ip
class MTcpIpI : public MyThreadX
{
private:
    Int_t fPortRx;

    Int_t Thread();

    virtual void ReadSocket(TSocket &rx) = 0;

public:
    MTcpIpI(Int_t rx) : MyThreadX(Form("MTcpIpI::%d", rx)), fPortRx(rx) { /*RunThread();*/ }
    ~MTcpIpI() { CancelThread(); }
};


// A generalized class for sending over tcp/ip
class MTcpIpO
{
private:
    TSocket *fTxSocket;

public:
    MTcpIpO(Int_t tx);
    ~MTcpIpO();

    static bool SendFrame(TSocket &tx, const char *msg, int len);
    static bool SendFrame(const char *addr, int port, const char *msg, int len);

    bool Send(const char *msg, int len);
};

// This class es espcially meant to receive and send ascii messages
class MTcpIpIO : public MTcpIpI, public MTcpIpO
{
private:
    void ReadSocket(TSocket &rx);

public:
    MTcpIpIO(Int_t tx, Int_t rx);
    ~MTcpIpIO();

    virtual bool InterpreteStr(TString str);
};

#endif
