#ifndef COSY_MTracking
#define COSY_MTracking

#ifndef COSY_MSlewing
#include "MSlewing.h"
#endif

#ifndef MARS_MThread
#include "MThread.h"
#endif

class RaDec;
class SlaStars;

class MTracking : public MSlewing, public MThread
{
private:
    Float_t fTrackAcc;
    Float_t fTrackDec;

    //Int_t fSePosZd1;
    //Int_t fSePosZd2;
    //Int_t fSePosAz;

    //Int_t fRePosZd1;
    //Int_t fRePosZd2;
    //Int_t fRePosAz;

    //ZdAz    fRePos;  // Offset between se and re coordinate system [re]
    //ZdAz    fSePos;  // Shaftencoder Position

    MLog   *fOut;

    bool RequestRePos();
    bool SetVelocity(const ZdAz &v);
    bool LimitSpeed(ZdAz *vt, const SlaStars &sla) const;
    bool InitTracking();
    ZdAz GetPointingPosRE(Bool_t pdo=kFALSE) const;

    Int_t Thread();

public:
    MTracking(MCosy *cosy) : MSlewing(cosy), MThread("MTracking"), fTrackAcc(0.1), fTrackDec(0.1), fOut(0) { }

    void TrackPosition(const RaDec &dst); // ra, dec [rad]
    void SetTrackAccDec(Float_t acc, Float_t dec) { fTrackAcc=0.1; fTrackDec=0.1; }

    void SetOut(MLog *fout) { fOut = fout; }

    ClassDef(MTracking, 0)
};

#endif
