// amccmdserversocket.h: Schnittstelle fr die Klasse CoCoControler.
//
//////////////////////////////////////////////////////////////////////

#ifndef AMCCMDSERVERSOCKET_H
#define AMCCMDSERVERSOCKET_H

#include <qserversocket.h>
#include <qtimer.h>

class ActiveMirrorControl;

class AMCCmdServerSocket : public QServerSocket
{
    Q_OBJECT

public:
	AMCCmdServerSocket( QObject* parent=0 );
	virtual ~AMCCmdServerSocket();
	void newConnection( int socket );

signals:
    void newConnect();
    void endConnect();
    void cmdFromCC( QString p_qsCommand );
    void reportFromCC( QString p_qsCommand );
    void errorFromSocket( QString p_qsCommand );

private slots:
    void readClient();
    void discardClient();
    void error( int p_iErrno );
    void timeout();

private:
	  ActiveMirrorControl*	m_pParent;
		QTimer								m_qtTimer;
};

#endif
