/////////////////////////////////////////////////////////////////
//
// COREventEnd
//
//  Created: Tue Apr 28 16:27:14 1998
//  Author:  Jose Carlos Gonzales
//  Purpose: Base class for EventEnd-classes
//  Notes:   
//
/////////////////////////////////////////////////////////////////

// @T \newpage

// @section Source code of {\tt COREventEnd.hxx}

/* @text
This section shows the include file {\tt COREventEnd.hxx}
@endtext */

#ifndef COREventEnd_Class
#define COREventEnd_Class

// @subsection Include files

// @code
#include "TROOT.h"
#include "TObject.h"

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

// @endcode

// @subsection Class {\em COREventEnd}: Definition

// @code
class COREventEnd {

public:

  char         EVTE[4];
  Float_t      EvtNumber;

  Float_t      dmmy[271];
  
public:
  COREventEnd(void) {}  // default constructor

  virtual ~COREventEnd(void) {}  // default destructor
  
  // reads EventEnd from binary input stream
  Int_t read ( ifstream &is ) {
    is.read ( (char *)this, sizeof( float ) * 273 ); 
    return is.gcount();
  }

  // writes EventEnd to binary output stream
  Int_t write ( ofstream &os ) {
    os.write ( (char *)this, sizeof( float ) * 273 ); 
    return 0;
  }
  
  // get information about the EventEnd

  // print-out of the EVTE
  void print(void);
  
  // get the event number
  inline Float_t get_eventnumber ( void ) { return (EvtNumber); }

  // fill Event end
  inline void fill ( Float_t theEvtNumber ) {
           
      strcpy(EVTE,"EVTE");
      EvtNumber = theEvtNumber;
      
      for (Int_t i=0; i<271; i++){
        dmmy[i]=0.;
      }
      
    return; 
  }

};
// @endcode

#endif  // not defined COREventEnd_Class
