/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Daniela Dorner, 01/2005 <mailto:dorner@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2006
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//
// resetallruns.C
// ==============
//
// This macro resets the values of a column in the table RunProcessStatus. It
// is used by the script filesondisk to reset the values for the columns,
// which indicate the availability of the files.
//
// Usage:
//   .x resetallrun.C+("filename", "column")
// The first argument is giving a file, in which a list of runs can be found
// for which the column will be set to Now() by this macro. The second
// argument is giving the column, which has to be reset.
//
// Make sure, that database and password are corretly set in a resource
// file called sql.rc and the resource file is found.
//
// Returns 0 in case of failure and 1 in case of success.
//
/////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <fstream>

#include <TSQLRow.h>
#include <TSQLResult.h>

#include "MSQLServer.h"

using namespace std;


int resetallruns(TString filename, TString column)
{
    MSQLServer serv("sql.rc");
    if (!serv.IsConnected())
    {
        cout << "ERROR - Connection to database failed." << endl;
        return 0;
    }
    cout << "resetallruns" << endl;
    cout << "------------" << endl;
    cout << endl;
    cout << "Connected to " << serv.GetName() << endl;
    cout << endl;

    //reset column to NULL
    TString query(Form("UPDATE RunProcessStatus SET %s=NULL",
                       column.Data()));
    //if the column is fCaCoFileAvail, reset also the column fCaCoFileFound
    if (column.Contains("CaCo"))
        query+=", fCaCoFileFound=NULL";

    cout << "q: " << query << endl;

    TSQLResult *res = serv.Query(query);
    if (!res)
    {
        cout << "updating (setting " << column.Data() << "= NULL) didn't work " << endl;
        return 0;
    }
    delete res;


    //read in file
    ifstream fin(filename);
    if (!fin)
    {
        cout << "file: " << filename << " missing!" << endl;
        return 0;
    }
    while (1)
    {
        //get runnumber
        TString runnumber;
        runnumber.ReadLine(fin);
        if (!fin)
            break;

        //build query and set status for this run to Now()
        TString query(Form("UPDATE RunProcessStatus SET %s=Now()", column.Data()));

        if (column.Contains("CaCo"))
            query+=Form(", fCaCoFileFound=%d", atoi(runnumber));

        query+=Form(" WHERE fRunNumber=%d ", atoi(runnumber));

        cout << "q2: " << query << endl;

        res = serv.Query(query);
        if (!res)
        {
            cout << "updating (setting " << column.Data() << " = Now()) for run# " << atoi(runnumber) << ") didn't work " << endl;
            return 0;
        }
        delete res;
    }

    return 1;
}


