##################################################################
#
#   makefile
# 
#   for the MARS software
#
##################################################################
# @maintitle

# @code

#
#  ----->>>   settings for compiler
#

CC     = gcc
CXX    = g++
AR     = ar -rc
AS     = as
LD     = ld
RANLIB = ranlib

#
#  ----->>>   settings for compilation
#

PROGRAMS  = cosy


ROOTFLAGS = `root-config --cflags`
ROOTGLIBS = `root-config --glibs`

#
#  connect the include files defined in the config.mk file
#
#    WARNING: the result (whether the linkage works or not) depends on the
#             order of the libraries
#
#
LIBS      = -L/usr/lib -lstdc++ -lpthread 
INCLUDES  = -Iincl -I.

WARNING   = -Wall -fno-rtti -fno-exceptions 
OPTIM     = -O2
DEBUG 	  = -g 
DEFINES	  = -DCPU=486 -DBUS_LITTLE_ENDIAN -DDEBUG=0 -DLINUX -DSHOW 

CFLAGS    = $(OPTIM) $(DEBUG) $(WARNING) $(INCLUDES) $(ROOTFLAGS) $(DEFINES)
CXXFLAGS  = $(CFLAGS)

#
# uncomment this for quiet compilation
#


include Makefile.conf.general

# @endcode 

# @code 

CINT     = M

#
#  ----->>>   mars libraries
#

#------------------------------------------------------------------------------
.SILENT:

.SUFFIXES: .c .cc .h .o 

SRCFILES = 

SRCS    = $(SRCFILES)
HEADERS = $(SRCFILES:.cc=.h)
OBJS    = $(SRCFILES:.cc=.o) 

############################################################

all: rmlib $(PROGRAMS)

#dox:
#	@echo " Creating html documentation:"
#	root -b -q dohtml.C


include Makefile.rules

clean:	rmlib rmcint rmobjs rmcore rmbin

mrproper:	clean rmbak
	@rm -f macros/*~
	@rm -rf htmldoc
	@echo "cd mbase"
	@cd mbase; make mrproper; cd ..
	@echo "cd .."
	@echo "cd mraw"
	@cd mraw; make mrproper; cd ..
	@echo "cd .."
	@echo "cd mgui"
	@cd mgui; make mrproper; cd ..
	@echo "cd .."
	@echo "cd mdatacheck"
	@cd mdatacheck; make mrproper; cd ..
	@echo "cd .."


# @endcode
