/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2008
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////////
//
// dohtml.C
// ========
//
// This is a service macro used to create the html-documentation from
// source code (THtml)
//
// Add here all directories in which files are stored from which the
// documentation should be created an add all macros which should be
// converted to HTML.
//
///////////////////////////////////////////////////////////////////////////

void dohtml()
{
    //
    //  don't forget that the shared object must have been loaded
    //

    //
    // Do not print 'Info' messages from the root system such like
    // TCanvas::Print
    //
    gErrorIgnoreLevel=kWarning;

    //
    //   create the html document class
    //
    THtml html;

    TString sourcedir;
    sourcedir += "base:";
    sourcedir += "candrv:";
    sourcedir += "caos:";
    sourcedir += "catalog:";
    sourcedir += "devdrv:";
    sourcedir += "gui:";
    sourcedir += "main:";
//    sourcedir += "mvideo:";
    sourcedir += "tcpip:";
    sourcedir += "tpoint:";
    sourcedir += "videodev:";
    sourcedir += ".:";

    html.SetSourceDir(sourcedir);
    html.SetOutputDir("htmldoc");

    html.MakeAll(kTRUE);

    html.SetSourceDir("macros");
//    html.Convert("merpp.C",                     "MARS - Merging and Preprocessing");
}
