#ifndef COSY_MStarguider
#define COSY_MStarguider

#include "PixClient.h"
#include "MGImage.h"

#include "MPointing.h"

#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif
#ifndef MARS_MTime
#include "MTime.h"
#endif
#ifndef MARS_MGList
#include "MGList.h"
#endif

class TArrayF;
class TGLabel;
class TGButton;
class TString;
class TSocket;

class TTimer;

class TGMenuBar;
class TGPopupMenu;
class TGTextEntry;

class PixGetter;

class MGImage;
class MGCoordinates;

class StarCatalog;
class MStarList;
class MCosy;
class MCaos;
// class MStargLeds;
class MStargHistograms;
class MGNumStars;
class MGStarg;
class FilterLed;
class Ring;

class Leds;

class MStarguider : public PixClient, public TGMainFrame
{
private:
    PixGetter     *fGetter;

    MGList        *fList;

    TGMenuBar     *fMenu;
    MGImage       *fImage;
    MGImage       *fZoomImage;

    MGStarg       *fGStarg;
    MGNumStars    *fGNumStars;

    TGPopupMenu   *fDisplay;
    TGPopupMenu   *fMode;
    TGPopupMenu   *fWritePictures;
    TGPopupMenu   *fSetup;
    TGPopupMenu   *fOperations;

    TGPopupMenu   *fFileType;
    TGPopupMenu   *fWriteType;
    TGPopupMenu   *fWriteRate;
    TGPopupMenu   *fInterpol;
    TGPopupMenu   *fLimMag;
    TGPopupMenu   *fChannel;

    TGPopupMenu   *fCaosWrite;
    TGPopupMenu   *fCaosPrint;
    TGPopupMenu   *fCaosAnalyse;
    TGPopupMenu   *fCaOs;

    MGCoordinates *fCRaDec;
    MGCoordinates *fCZdAz;

    MGCoordinates *fPZdAz;
    MGCoordinates *fDZdAz;
    MGCoordinates *fSZdAz;

    TGTextEntry   *fPixSize;
    TGTextEntry   *fAngle;
    TGTextEntry   *fCut;

    TGLabel       *fFps;
    TGLabel       *fPosZoom;
    TGLabel       *fSkyBright;
    TGLabel       *fCZdAzText;
    TGLabel       *fPZdAzText;
    TGLabel       *fDZdAzText;

    TGButton      *fTPoint;
    TGButton      *fStargTPoint;

    ZdAz          fPos;
    ZdAz          fD;
    AltAz         fAltAzOffsetFromTp;

    Int_t          fNumStarsDetected;
    Int_t          fNumStarsCorrelated;

    StarCatalog   *fSao;
    MCosy         *fCosy;
    MCaos         *fCaos;
    MCaos         *fStargCaos;
    TSocket       *fAmcSocket;
    MStargHistograms *fStargHistograms;
    
    RaDec *fRaDec;

    TTimer *fTimer;
    MTime   fTime;
    MTime   fTimeFromTp;

    ofstream *fOutTp;
    ofstream *fOutStargTp;
    ofstream *fOutRq;

    Int_t fDx;
    Int_t fDy;

    byte fIntRate;
    int  fWrtRate;

    UInt_t fStatus;
    Double_t fLastBright;

    void SetPixSize(const double pixsize);
    void Toggle(TGPopupMenu *p, UInt_t id);
    void SwitchOff(TGPopupMenu *p, UInt_t id);
    void ToggleStargAnalysis();
    void ToggleFindStar();
    void ToggleStarguider();
    void ToggleCaosFilter();
    void SetChannel();
    //void GetCoordinates();
    Int_t CalcTrackingError(Leds &, MStarList &, ZdAz &, MTime &, double &bright, Int_t &num);
    //void CalcTrackingError(Leds &, MStarList &);
    ZdAz TrackingError(TArrayF &alt, TArrayF &az, TArrayF &mag, Int_t &num) const;
    bool Interpolate(const unsigned long n, byte *img) const;

    XY FindRoqueLamp(FilterLed &f, FilterLed &f2, Ring &CameraCenter, MTime &t,
                     Double_t cut, Int_t box, XY SearchCenter);

    ZdAz FindStar(FilterLed &f, FilterLed &f2, Ring &center, MTime &t, 
		  Double_t cut, Int_t box, Double_t scalefactor);

    //void InitHists();
    //void InitGraphs();
    void InitGui(Int_t channel);

    bool SendAmcTrigger(const char *msg);

    //void OpenFile();

    //void ResetHists();
    //void DisplayAnalysis();
    void UpdatePosZoom();

    Bool_t HandleTimer(TTimer *t);
    //Bool_t HandleKey(Event_t* event);

public:
    MStarguider(MObservatory::LocationName_t obs, Int_t channel);
    virtual ~MStarguider();

    //void Update();

    void Layout();
    void CloseWindow();

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);

    Bool_t HandleDoubleClick(Event_t *event);
    //Bool_t HandleButton(Event_t *);

    void SetPointingPosition(RaDec rd);
    void SetCosy(MCosy *c) { fCosy = c; }

    XY GetCoordinates() const;

    //
    // Execution of one frame - this function may be overloaded!
    //
    void ProcessFrame(const unsigned long n, byte *img, struct timeval *tm);

    void Print(TString &str, Double_t deg) const;
    void Print(Option_t *o) const { }

    ClassDef(MStarguider, 0)
};

#endif


