#ifndef MARS_MCorsikaEvtHeader
#define MARS_MCorsikaEvtHeader

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TVector3
#include <TVector3.h>
#endif

// gcc 3.2
//class ifstream;
#include <iosfwd>

class MCorsikaRunHeader;

class MCorsikaEvtHeader : public MParContainer
{
private:
    UInt_t   fEvtNumber;              // Event number
    UInt_t   fParticleID;             // Particle ID (see MMcEvtBasic or CORSIKA manual)
    Float_t  fTotalEnergy;            // [GeV] 

    Float_t  fStartAltitude;          // [g/cm]
    Float_t  fFirstTargetNum;         // Number of first target if fixed
    Float_t  fFirstInteractionHeight; // [cm] z coordinate, first intercation height

    Float_t  fMomentumX;              // [GeV/c]
    Float_t  fMomentumY;              // [GeV/c]
    Float_t  fMomentumZ;              // [GeV/c]

    Float_t  fZd;                     // [rad] Zenith distance
    Float_t  fAz;                     // [rad] Azimuth (north=0; west=90)

    Float_t  fX;                      // [cm] Position of telescope on ground x / - impact parameter x
    Float_t  fY;                      // [cm] Position of telescope on gorund y / - impact parameter y

    Float_t  fWeightedNumPhotons;     // weighted number of photons arriving at observation level

public:
    MCorsikaEvtHeader(const char *name=NULL, const char *title=NULL);

    //void Clear(Option_t * = NULL);
    void Print(Option_t * = NULL) const;

    TVector3 GetMomentum() const { return TVector3(fMomentumX, fMomentumY, fMomentumZ); }
    TVector2 GetImpactPos() const { return TVector2(fX, fY); }

    Float_t GetTotalEnergy() const { return fTotalEnergy; }
    Float_t GetFirstInteractionHeight() const { return fFirstInteractionHeight; }

    Float_t GetZd() const { return fZd; }
    Float_t GetAz() const { return fAz; }

    Float_t GetX() const { return fX; }
    Float_t GetY() const { return fY; }

    Int_t ReadEvt(istream& fin, MCorsikaRunHeader &header);    // read in event header block
    Bool_t ReadEvtEnd(istream& fin); // read in event end block

    ClassDef(MCorsikaEvtHeader, 1) // Parameter Conatiner for raw EVENT HEADER
}; 

#endif
