#ifndef MARS_MSimCamera
#define MARS_MSimCamera

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MPhotonEvent;
class MPhotonStatistics;
class MRawRunHeader;
class MAnalogChannels;

class MSpline3;

class MSimCamera : public MTask
{
private:
    MPhotonEvent      *fEvt;        //! Event stroing the photons
    MPhotonStatistics *fStat;       //! Valid time range of the phootn event
    MRawRunHeader     *fRunHeader;  //! Sampling frequency

    MAnalogChannels   *fCamera;     //! Output of the analog signals

    MSpline3 *fSpline;

    // MTask
    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MSimCamera(const char *name=NULL, const char *title=NULL);

    ClassDef(MSimCamera, 0) // Task to simulate the electronic noise and to convert photons into pulses
};

#endif
