#ifndef MHMCCOLLECTIONAREA_H
#define MHMCCOLLECTIONAREA_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

//
// because of some strange reason this cannot be put into MonteCarloIncl
//
#ifndef ROOT_TH1
#include <TH1.h>
#endif

class TH2D;

class MHMcCollectionArea : public MParContainer
{
private:
    TH2D *fHistAll; //! all simulated showers
    TH2D *fHistSel; //! the selected showers

    TH1D *fHistCol; //  the collection area

public:

    MHMcCollectionArea(const char *name=NULL, const char *title=NULL);
    ~MHMcCollectionArea();

    void FillAll(Float_t log10E, Float_t radius);
    void FillSel(Float_t log10E, Float_t radius);

    void DrawAll(Option_t *option = "");
    void DrawSel(Option_t *option = "");
    void Draw   (Option_t *option = "");

    void CalcEfficiency();

    ClassDef(MHMcCollectionArea, 1)  //  Data Container to calculate Collection Area
};

#endif
