#ifndef COSY_SlaPlanets
#define COSY_SlaPlanets

#ifndef COSY_Slalib
#include "Slalib.h"
#endif

#ifndef MARS_MPointing
#include "MPointing.h"
#endif

typedef enum
{
    kESun      = 0,
    kEMercury  = 1,
    kEVenus    = 2,
    kEMoon     = 3, // earth moon barycentre
    kEMars     = 4,
    kEJupiter  = 5,
    kESaturn   = 6,
    kEUranus   = 7,
    kENeptune  = 8,
    kEPluto    = 9
} ePlanets_t;

class SlaPlanets : public Slalib
{
private:
    double fDt;        // [mjd] const: rootcint/TMemberInspector
    double fTt;        // [mjd] timescale TT

    ZdAz fZdAz[10];    // [rad]

    double fEarth[3];  // heliocentric coordinates

    ZdAz   GetMoonPos() const;

public:
    SlaPlanets(MObservatory::LocationName_t key);
    virtual ~SlaPlanets();

    void SetMjd(double mjd);

    void UpdatePlanetPos(ePlanets_t planet);
    ZdAz GetPlanetPos(ePlanets_t planet) const { return fZdAz[planet]; }

    ClassDef(SlaPlanets, 0)

};

#endif
