/***************************************************************************
                          amcstate.h  -  description
                             -------------------
    begin                : Fri Apr 4 2003
    copyright            : (C) 2003 by Martin Merck
    email                : merck@astro.uni-wuerzburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMCSTATE_H
#define AMCSTATE_H

#include <qwidget.h>

/**State of the AMC.
  *@author Martin Merck
  */

#define AMC_STATE_ERROR					0
#define AMC_STATE_PARKED				1
#define AMC_STATE_INITIALIZED		2
#define AMC_STATE_READJUST			3
#define AMC_STATE_ADJUSTED			4
#define AMC_STATE_LASERADJUSTED	5
#define AMC_STATE_MOVING				6
#define AMC_STATE_UNDEFINED			7
#define AMC_STATE_USER					8
#define AMC_STATE_NOT_AVAILABLE	9
#define AMC_STATE_UNKNOWN				10

class AMCState : public QObject  {
   Q_OBJECT

public:
	AMCState( QObject *parent=0, const char* name=0 );
	~AMCState();
  /** Return the actual state. */
  int getState() const;
  /** Set the state. */
  void setState( int p_iState );
  /** Set the number of installed panels. */
  void setZdAz( double p_dZd, double p_dAz ) { m_dZd = p_dZd; m_dAz = p_dAz; };
  /** Set the number of installed panels. */
  void setInstalledPanels( int p_iPanels ) { m_iInstalledPanels = p_iPanels; };
  /** Set the number of installed panels. */
  void setErrorPanels( int p_iPanels ) { m_iErrorPanels = p_iPanels; };
  /** Set the number of installed panels. */
  int installedPanels() { return m_iInstalledPanels; };
  /** Set the number of installed panels. */
  int errorPanels() { return m_iErrorPanels; };
  /** Get a textual description of the state. */
  const QString& getText( int p_iState ) const;

private: // Private attributes
  /** Variable holding the actual state. */
  int m_iState;
  /** Variable holding the Lid state. */
  int m_iStateLid;
  /** Variable holding the LED state. */
  int m_iStateLEDs;
  /** Variable holding the number of installed panels. */
  int m_iInstalledPanels;
  /** Variable holding the number of panels with errors. */
  int m_iErrorPanels;
  /** Zenith distance reported by the drive system */
  double m_dZd;
  /** Azimuth reported by the drive system */
  double m_dAz;
  /**  */
  QString* m_qsStateTxtTable[11];

signals: // Signals
  /** Signal emitted when the state changes. */
  void stateChanged( int p_iOldState, int p_iNewState );
};

#endif
