#ifndef COSY_PngReader
#define COSY_PngReader

#ifndef MARS_MThread
#include "MThread.h"
#endif

#ifndef COSY_PixGetter
#include "PixGetter.h"
#endif

class PixClient;

class PngReader : public PixGetter, public MThread
{
private:
    //
    // Geometry
    //
    static const int gfCols  = 768;
    static const int gfRows  = 576;
    static const int gfDepth = 3;

    //
    // Thread interface
    //
    unsigned long fNum;

    char fImg[gfCols*gfRows];
    struct timeval fTime;

    PixClient &fClient;

    //
    // Hardware dependant functions
    //
    char *GetImg(unsigned int frame);

    //
    // Execution thread which processes the pictures
    //
    Int_t Thread();

public:
    PngReader(PixClient &client);
    virtual ~PngReader();

    void ExitLoop() { CancelThread(); }

    ClassDef(PngReader, 0)
};

#endif
