#ifndef COSY_MDriveCom
#define COSY_MDriveCom

#ifndef COSY_MCeCoCom
#include "MCeCoCom.h"
#endif

class RaDec;
class ZdAz;
class MsgQueue;
class Ring;
class MLog;

class MDriveCom : public MCeCoCom
{
private:
    MsgQueue *fQueue;

    bool ReadAngle(TString &str, Double_t &d);
    bool ReadPosition(TString &str, Double_t &d1, Double_t &d2);

    bool InterpreteCmd(TString cmd, TString str);
    void Print(TString &str, Double_t deg) const;

    bool CommandRADEC(TString &str);
    bool CommandGRB(TString &str);
    bool CommandZDAZ(TString &str);
    bool CommandPREPS(TString &str);
    bool CommandARM(TString &str);
    bool CommandTPOINT(TString &str);
    bool CommandSTGMD(TString &str);

public:
    enum
    {
        kError      = 0x01,
        kMoving     = 0x02,
        kTracking   = 0x04,
        kStopping   = 0x08,
        kStopped    = 0x10,
	kStandby    = 0x20,
	kMonitoring = 0x40
    };

    MDriveCom(MsgQueue *q, const char *addr, const int tx, const int rx, MLog *out=NULL) : MCeCoCom(addr, tx, rx, out), fQueue(q) {}
    MDriveCom(const char *addr, const int tx, const int rx, MLog *out=NULL) : MCeCoCom(addr, tx, rx, out), fQueue(NULL) {}

    void SetMsgQueue(MsgQueue *q) { fQueue = q; }


    bool SendReport(UInt_t stat, RaDec rd, ZdAz so, ZdAz is, ZdAz er, Bool_t armed);
    bool SendStargReport(UInt_t stat, ZdAz miss, ZdAz nompos, Ring center, Int_t num, Int_t n, Double_t bright, Double_t mjd, Int_t numleds, Int_t numrings);
    bool SendTPoint(UInt_t stat);
    bool SendStatus(const char *stat);
};

#endif
