#include "SlaPlanets.h"

#include <iostream>

#include "slalib.h"

ClassImp(SlaPlanets);

using namespace std;

SlaPlanets::SlaPlanets(MObservatory::LocationName_t key) : Slalib(key), fDt(slaDt(2000.0)/60./60./24.)
{
}

SlaPlanets::~SlaPlanets()
{
}

void SlaPlanets::SetMjd(double mjd)
{
    Slalib::SetMjd(mjd);

    fTt = GetMjd() + slaDtt(GetMjd())/60./60./24.;

    //
    // coordinates of earth: heliocentric, equatoril, J2000
    //
    double veb[3]; // barycentric velocity
    double ceb[3]; // barycentric coordinates
    double veh[3]; // heliocentric velocity

    slaEvp(GetMjd() + fDt, 2000.0, veb, ceb, veh, fEarth);
}

void SlaPlanets::UpdatePlanetPos(ePlanets_t planet)
{
    //
    // coordinates of planet: topocentric, equatorial, J2000
    //
    double ra, dec, diam;

    // One can use TT instead of TDB for all planets
    // (except the moon)
    // TDB, planet, elong, phi, *ra, *dec, *diam
    slaRdplan(fTt, planet, GetElong(), GetPhi(), &ra, &dec, &diam);

    double az, el;
    slaDe2h(GetAlpha()-ra, dec, GetPhi(), &az, &el);

    fZdAz[planet].Set(TMath::Pi()/2-el, az);
}
