#ifndef COSY_MTracking
#define COSY_MTracking

#ifndef COSY_MSlewing
#include "MSlewing.h"
#endif

#ifndef MARS_MThread
#include "MThread.h"
#endif

class MLog;
class RaDec;
class SlaStars;

class MTracking : public MSlewing, public MThread
{
private:
    ZdAz fTrackAcc;

    MLog   *fOut;

    bool SetVelocity(const ZdAz &v);
    bool LimitSpeed(const ZdAz &vt, const SlaStars &sla) const;
    bool InitTracking();

    Int_t Thread();

public:
    MTracking(MCosy *cosy) : MSlewing(cosy), MThread("MTracking"), fTrackAcc(0, 0), fOut(0) { }

    void TrackPosition(const RaDec &dst); // ra, dec [rad]
    void SetTrackAcc(Float_t zd, Float_t az) { fTrackAcc.Zd(zd); fTrackAcc.Az(az); }

    void SetOut(MLog *fout) { fOut = fout; }

    ClassDef(MTracking, 0)
};

#endif
