#ifndef COSY_TPointStar
#define COSY_TPointStar

#ifndef ROOT_TObject
#include <TObject.h>
#endif

//class istream;
//class ostream;

class ZdAz;
class AltAz;

class MPointing;

class TPointStar : public TObject
{
    friend istream &operator>>(istream &fin,  TPointStar &set);
    friend ostream &operator<<(ostream &fout, TPointStar &set);
private:
    Double_t fStarAz;
    Double_t fStarEl;

    Double_t fRawAz;
    Double_t fRawEl;

    Double_t fMag;
public:
    TPointStar(Double_t sel=0, Double_t saz=0, Double_t rel=0, Double_t raz=0);/*
        fStarAz(saz*TMath::DegToRad()),
        fStarEl(sel*TMath::DegToRad()),
        fRawAz(raz*TMath::DegToRad()),
        fRawEl(rel*TMath::DegToRad()), fMag(-25)
    {
    }*/

    Double_t GetMag() const { return fMag; }
    Double_t GetResidual(Double_t *err=0) const;

    void operator=(TPointStar &set)
    {
        fStarAz = set.fStarAz;
        fStarEl = set.fStarEl;
        fRawAz  = set.fRawAz;
        fRawEl  = set.fRawEl;
        fMag    = set.fMag;
    }

    Double_t GetDEl() const;//     { return (fRawEl-fStarEl)*TMath::RadToDeg(); }
    Double_t GetDZd() const;//     { return -GetDEl(); }
    Double_t GetDAz() const;//     { return (fRawAz-fStarAz)*TMath::RadToDeg(); }
    Double_t GetStarEl() const;//  { return fStarEl*TMath::RadToDeg(); }
    Double_t GetStarZd() const;//  { return 90.-fStarEl*TMath::RadToDeg(); }
    Double_t GetStarAz() const;//  { return fStarAz*TMath::RadToDeg(); }
    Double_t GetRawEl() const;//   { return fRawEl*TMath::RadToDeg(); }
    Double_t GetRawAz() const;//   { return fRawAz*TMath::RadToDeg(); }
    Double_t GetRawZd() const;//   { return 90.-fRawEl*TMath::RadToDeg(); }

    ZdAz  GetStarZdAz() const;//   { return ZdAz(TMath::Pi()/2-fStarEl, fStarAz); }
    AltAz GetStarAltAz() const;//  { return AltAz(fStarEl, fStarAz); }

    ZdAz  GetRawZdAz() const;//    { return ZdAz(TMath::Pi()/2-fRawEl, fRawAz); }
    AltAz GetRawAltAz() const;//   { return AltAz(fRawEl, fRawAz); }

    void AdjustEl(Double_t del);// { fStarEl += del*TMath::DegToRad(); }
    void AdjustAz(Double_t daz);// { fStarAz += daz*TMath::DegToRad(); }

    void Adjust(const MPointing &bend);/*
    {
        AltAz p = bend(GetStarAltAz());
        fStarEl = p.Alt();
        fStarAz = p.Az();
    }*/
    void AdjustBack(const MPointing &bend);/*
    {
        AltAz p = bend.CorrectBack(GetRawAltAz());
        fRawEl = p.Alt();
        fRawAz = p.Az();
    }*/
    ClassDef(TPointStar, 1)
};

/*
class TPoint : public TPointStar
{
public:
    TPoint(Double_t sel=0, Double_t saz=0, Double_t rel=0, Double_t raz=0)
        : TPointStar(sel, saz, rel, raz)
    {
    }
    ClassDef(TPoint, 1)
};
*/

istream &operator>>(istream &fin, TPointStar &set);
ostream &operator<<(ostream &out, TPointStar &set);

#endif
