/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MMonteCarlo.h"

#include <TGButton.h>       // TGTextButton

ClassImp(MMonteCarlo)

enum {
    M_BUTTON_ACTION
};

MMonteCarlo::MMonteCarlo(const TGWindow *main, const TGWindow *p,
                         const UInt_t w, const UInt_t h)
: MBrowser(main, p, w, h)
{
    TGTextButton *action = new TGTextButton(fTop1, "ACTION", M_BUTTON_ACTION);
    fList->Add(action);
    action->Associate(this);

    TGLayoutHints *laybut = new TGLayoutHints(kLHintsTop|kLHintsLeft, 10, 10, 5, 5);
    fList->Add(laybut);

    fTop1->AddFrame(action, laybut);

    MapSubwindows();

    Layout();

    SetWindowName("MonteCarlo Main");
    SetIconName("MonteCarlo");

    MapWindow();
} 

// ======================================================================

Bool_t MMonteCarlo::ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2)
{     
    if (GET_MSG(msg) == kC_COMMAND &&
        GET_SUBMSG(msg) == kCM_BUTTON &&
        parm1 == M_BUTTON_ACTION)
    {
        DisplInfo("Put Intelligence here!");
        return kTRUE;
    }

    return MBrowser::ProcessMessage(msg, parm1, parm2);
}
