#ifndef PERIODICSIGNAL
#define PERIODICSIGNAL
//for signals
#include <sigc++/signal_system.h>
using namespace SigC;
//for threads
#include <pthread.h>

class PeriodicSignal
{
private:
  unsigned int period;//in usec
public:
    Signal0<void> signal;
    
    PeriodicSignal(unsigned int period_);
    void Start();
    void Stop();

private:
    static void * SleepPeriodAndSignal( void* arg);    
    pthread_mutex_t  mutex4stop;
    bool stopped;
    pthread_t thread;

};
#endif
