#ifndef COSY_Slalib
#define COSY_Slalib

#ifndef MARS_MTime
#include "MTime.h"
#endif

#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif

class ZdAz;

class Slalib : public MObservatory
{
private:
    MTime fTime;

    double fAlpha;

    static Double_t Trunc(Double_t val);

public:
    Slalib(MObservatory::LocationName_t key);

    virtual void SetMjd(double mjd);
    Double_t GetMjd() const { return fTime.GetMjd(); }
    void Now(double offset=0);
    const MTime &GetTime() const { return fTime; }

    double GetAlpha() const  { return fAlpha; }

    ZdAz   XYZ2ZdAz(double coord[3]) const;

    ClassDef(Slalib, 0)
};

#endif
