/*-----------------------------------------------------------------------------
mcal.h -- CAL Message Specifications

Copyright (c) 1994 JANZ Computer AG
All Rights Reserved

Created 94/10/11 by Soenke Hansen
Version 1.48 of 00/02/17

Definitions of message specifiers for message exchanged between
CAL and a CAL User (Application).

-----------------------------------------------------------------------------*/

#ifndef mcal_DEFINED
#define mcal_DEFINED

#ifdef __cplusplus
extern "C" {
#endif

/* Message specifiers (User -- DBT Slave) */
#define M_DBTS_CREATE		0x80  /* create user definition */
#define M_DBTS_CREATE_ALL	0x81  /* create all user definitions */
#define M_DBTS_DELETE		0x82  /* delete user definition */
#define M_DBTS_VERIFY		0x83  /* verify COB definition */
#define M_DBTS_CHECKSUM		0x84  /* get checksum */

/* Message specifiers (User -- NMT Slave) */
#define M_NMTS_STATE_ind	0x90  /* indicate NMT state change to user */
#define M_NMTS_PREPARE_ind	0x91  /* ask user to initiate preparation */
#define M_NMTS_IDENTIFY_ind	0x92  /* ind. for this node to identify */
#define M_NMTS_EVENT_ind	0x93  /* Node Event indication */
#define M_NMTS_RESET_NODE_ind	0x94  /* CANopen Reset Node indication */
#define M_NMTS_RESET_COMMUNICATION_ind	0x95  
				      /* CANopen Reset Communication indication */
#define M_NMTS_CONF_ind		0x96  /* config. services (with subspec!) */  
#define M_NMTS_CONF_DATA_ind	0x97  /* config. data services (w. subspec!) */

/* Message "sub-specifiers" with M_NMTS_CONF_[DATA_]ind */
#define M_NMTS_CONF_DL_DATA_ind		0x0001  /* config. download data ind. */
#define M_NMTS_CONF_DL_DATA_CONT_ind	0x0002  /* config. download data ind. */
#define M_NMTS_CONF_DL_FAIL_ind		0x0003  /* config. download fail. ind.*/
#define M_NMTS_CONF_DL_SUCC_ind		0x0004  /* config. download succ. ind.*/
#define M_NMTS_CONF_ABORT_ind		0x0005  /* config. transfer abort ind.*/
#define M_NMTS_CONF_VERIFY_ind		0x0006  /* config. protocol verify ind.*/

/* Failure codes (nmtm/ nmts configuration) */
#define	NMT_CONFIG_NO_ERR		0	/* no error */
#define NMT_CONFIG_TOGGLE_ERR		1	/* toggle error */
#define NMT_CONFIG_SIZE_ERR		2	/* mismatch of data size */
#define NMT_CONFIG_PROTOCOL_ERR		3	/* nomen est omen */
#define NMT_CONFIG_MEM_ERR		4	/* no more mem free */
#define NMT_CONFIG_RESTART_ERR		5	/* current up-/down-load will */
						/* be restarted */

/* Message specifiers (User -- LMT Slave) */
#define M_LMTS_MODE_ind		0x98  /* change of LMT mode */
#define M_LMTS_BUSON_ind	0x99  /* activate bit timing completed */
#define M_LMTS_BUSOFF_ind	0x9a  /* activate bit timing started */
#define M_LMTS_NMTADDR_ind	0x9b  /* new NMT address (partial) */
#define M_LMTS_BTR_ind		0x9c  /* new Bit Timing */
#define M_LMTS_STORE_ind	0x9d  /* Store Configuration */

/* Message specifiers (User -- NMT Master) */
#define M_NMTM_CONNECT_ind	0xa0  /* indicate end of Node Connect svc */
#define M_NMTM_PREPARE_ind	0xa1  /* indicate end of Node Prepare svc */
#define M_NMTM_IDENTIFY_ind	0xa2  /* Identify Node indication */
#define M_NMTM_EVENT_ind	0xa3  /* Network Event indication */
#define M_NMTM_CONF_ind		0xa4  /* config. services (with subspec!) */

/* Message "sub-specifiers" with M_NMTM_CONF_ind */
#define M_NMTM_CONF_DL_CONT_ind	0x0001  /* config. download continue ind. */
#define M_NMTM_CONF_DL_SUC_con	0x0002  /* config. download success conf. */
#define M_NMTM_CONF_DL_FAIL_con	0x0003  /* config. download failure conf. */
#define M_NMTM_CONF_UL_DATA_ind	0x0004  /* config. upload data ind. */
#define M_NMTM_CONF_UL_DACO_ind	0x0005  /* config. upload data continue ind. */
#define M_NMTM_CONF_UL_FAIL_con	0x0006  /* config. upload failure conf. */
#define M_NMTM_CONF_ABORT_ind	0x0007  /* config. transfer abort indication */
#define M_NMTM_CONF_VERIFY_con	0x0008  /* config. protocol verify conf.*/


/* Message specifiers (User -- CAL) */
#define M_NMTS			0xb0	/* user <--> NMT slave */
#define M_NMTM			0xb1	/* user <--> NMT master */
#define M_DBTS			0xb2	/* user <--> DBT slave */
#define M_DBTM			0xb3	/* user <--> DBT master */
#define M_LMTS			0xb4	/* user <--> LMT slave */
#define M_LMTM			0xb5	/* user <--> LMT master */
#define M_CMS_DEF		0xb6	/* user <--> CMS definition services */
#define M_CMS_DATA		0xb7	/* user <--> CMS data transfer */

/* CANopen (hardware-timer (TPU) dependant) timer configuration */
/* Message specifiers (User -- CANopen) */
#define M_CANOPEN			0xb8	/* user <--> CANopen */

#define	HI_RES_TIMER			0x0001	/* handle HiRes timestamping */
#define	TIME_OF_DAY_TIMER		0x0002	/* handle TimeOfDay timestamping */
#define	SYNC_TIMER			0x0004	/* handle SYNC timer */

/* Start of timestamp/sync messaging */
#define MS_CANOPEN_START_HI_RES_TS_req	0x0001	/* start HiRes timestamping (CANopen master) */
#define MS_CANOPEN_START_TOD_TS_req	0x0002	/* start TimeOfDay timestamping (CANopen master) */
#define MS_CANOPEN_START_SYNC_req	0x0003	/* start SYNC timer (CANopen master) */

/* single shot of timestamp/sync messaging */
#define MS_CANOPEN_TRIGGER_SINGLE_HI_RES_TS_req	0x0004 /* trigger HiRes (TIME-server) stamp once */
#define MS_CANOPEN_TRIGGER_SINGLE_TOD_TS_req	0x0005 /* trigger TimeOfDay (TIME-server) stamp once */

/* mapping the high resolution timestamp into a PDO */
#define	MS_CANOPEN_MAP_HI_RES_TIMESTAMP_req	0x0006	/* map HiRes timestamp (TIME-server) into PDO */

#define	MS_CANOPEN_DELETE_ALL_PDO_MAPPINGS_req	0x0007	/* PDO mapping configuration (CANopen slave) */
#define	MS_CANOPEN_ADD_PDO_MAPPING_req			0x0008	/* PDO mapping configuration (CANopen slave) */
#define	MS_CANOPEN_ADD_PDO_LENGTH_req			0x0009	/* PDO length configuration (CANopen slave) */
#define	MS_CANOPEN_ADD_PDO_TRANS_TYPE_req		0x000a	/* PDO transm. type configuration (CANopen slave) */
#define	MS_CANOPEN_CONTROL_PDO_req				0x000b	/* PDO dis-/enabling (CANopen slave) */
#define	MS_CANOPEN_ADJUST_COB_ID_req			0x000c	/* PDO COB-Id configuration (CANopen slave) */
#define	MS_CANOPEN_ADD_PDO_INHIB_TIME_req		0x000d	/* PDO inhibit-time configuration (CANopen slave) */
#define	MS_CANOPEN_TRIGGER_TPDO_req				0x000e	/* triggering of PDO for sending (CANopen slave) */
#define	MS_CANOPEN_TRIGGER_RPDO_req				0x000f	/* triggering of PDO for receiption (CANopen slave) */

/* Message sub-specifiers with M_NMTS */
#define MS_NMTS_CREATE_NODE_req		0x0000 /* create slave node */
#define MS_NMTS_DELETE_NODE_req		0x0001 /* delete slave node */
#define MS_NMTS_IDENTIFY_NODE_req	0x0002 /* send identify node */
#define MS_NMTS_CONNECT_NODE_req	0x0003 /* connect node */
#define MS_NMTS_DISCONNECT_NODE_req	0x0004 /* disconnect node */
#define MS_NMTS_PREPARE_REMOTE_NODE_res	0x0005 /* send prepare remote node response */
#define MS_NMTS_PREPARE_REMOTE_NODE_ind	0x0006 /* indicate prepare remote node request */
#define MS_NMTS_IDENTIFY_REMOTE_NODES_ind	0x0007 /* indicate request for nodes to identify */
#define MS_NMTS_STATE_ind		0x0008 /* indicate NMT state change */
#define MS_NMTS_EVENT_ind		0x0009 /* node event indication */
/* Definitions for CANopen relevant functions	*/
#define MS_NMTS_CREATE_COP_NODE_req	0x000a /* create CANopen slave node */
#define MS_NMTS_RESET_NODE_ind		0x000b /* CANopen reset node indication */
#define MS_NMTS_RESET_COMMUNICATION_ind	0x000c /* CANopen reset communication indication */
#define MS_NMTS_CONFIG_COP_NODE_req	0x000d /* conf. dflt. guard par. of CANopen slave */
#define MS_NMTS_CONFIG_DOWNLOAD_ind		0x000e	/* configuration download indication */
#define MS_NMTS_CONFIG_DOWNLOAD_CONT_ind	0x000f	/* configuration download continue indication */
#define MS_NMTS_CONFIG_DOWNLOAD_FAIL_ind	0x0011	/* configuration download failure indication */
#define MS_NMTS_CONFIG_NODE_req		0x0012 /* general purpose configuration of NMT slave */
#define MS_NMTS_CONFIG_ACK_res		0x0013 /* generate acknowledge for configuration download */
#define MS_NMTS_CONFIG_ABORT_TRANSFER_ind	0x0014 /* abort configuration transfer indication */
#define MS_NMTS_CONFIG_ABORT_TRANSFER_req	0x0015 /* abort configuration transfer indication */
#define MS_NMTS_CONFIG_VERIFY_ind	0x0016 /* verify configuration transfer indication */
#define MS_NMTS_CONFIG_VERIFY_res	0x0017 /* verify configuration transfer response */

/* Message sub-specifiers with M_DBTS */
#define MS_DBTS_DELETE_USERDEF_req	0x0000 /* delete user definition */
#define MS_DBTS_DELETE_USERDEF_con	0x0001 /* confirmation */
#define MS_DBTS_CREATE_ALL_USERDEF_req	0x0002 /* create all user definitions */
#define MS_DBTS_CREATE_ALL_USERDEF_con	0x0003 /* confirmation */
#define MS_DBTS_VERIFY_COBCLASS_req	0x0004 /* verify cob class */
#define MS_DBTS_VERIFY_COBCLASS_con	0x0005 /* confirmation */
#define MS_DBTS_GET_CHECKSUM_req	0x0006 /* get checksum */
#define MS_DBTS_GET_CHECKSUM_con	0x0007 /* confirmation */

/* Message sub-specifiers with M_LMTS */
#define MS_LMTS_BUSON_req		0x0000 /* switch to bus on state */
#define MS_LMTS_BUSOFF_req		0x0001 /* switch to bus off state */
#define MS_LMTS_CANCONF_req		0x0002 /* configure CANbus parameter */

/* Subrequests for CANCONF */
#define MS_LMTS_CANCONF_BERR	0x00	/* Configure bus-error detection */
#define MS_LMTS_CANCONF_EWL	0x01	/* Configure error warning limit */
#define MS_LMTS_CANCONF_LOM	0x02	/* Configure listen only mode */
#define MS_LMTS_CANCONF_STM	0x03	/* Configure self test mode */

/* Message sub-specifiers with M_NMTM */
#define MS_NMTM_ADD_REMOTE_NODE_req	0x0000 /* add remote node */
#define MS_NMTM_ADD_REMOTE_NODE_con	0x0001 /* confirmation */
#define MS_NMTM_REMOVE_REMOTE_NODE_req	0x0002 /* remove remote node */
#define MS_NMTM_CONNECT_REMOTE_NODE_req	0x0003 /* connect remote node */
#define MS_NMTM_CONNECT_REMOTE_NODE_con	0x0004 /* confirmation */
#define MS_NMTM_PREPARE_REMOTE_NODE_req	0x0005 /* prepare remote node */
#define MS_NMTM_PREPARE_REMOTE_NODE_con	0x0006 /* confirmation */
#define MS_NMTM_START_REMOTE_NODE_req	0x0007 /* start remote node */
#define MS_NMTM_STOP_REMOTE_NODE_req	0x0008 /* stop remote node */
#define MS_NMTM_DISCONNECT_REMOTE_NODE_req	0x0009 /* disconnect remote node */
#define MS_NMTM_IDENTIFY_REMOTE_NODES_req	0x000a /* identify remote nodes */
#define MS_NMTM_IDENTIFY_ind		0x000b /* identify node indication */
#define MS_NMTM_EVENT_ind		0x000c /* network event indication */
#define MS_NMTM_GET_RNODES_req		0x000d /* get remote nodes */
#define MS_NMTM_GET_RNODES_con		0x000e /* confirmation */
#define MS_NMTM_CONFIG_req		0x000f /* configuration */
/* Definitions for CANopen relevant functions	*/
#define MS_NMTM_ADD_REMOTE_COP_NODE_req	0x0010 /* add CANopen remote node */
#define MS_NMTM_ADD_REMOTE_COP_NODE_con	0x0011 /* confirmation */
#define MS_NMTM_ENTER_PRE_OPERATIONAL_STATE_req 0x0012	/* enter pre-operational state request */
#define MS_NMTM_RESET_NODE_req		0x0013 /* reset node request */
#define MS_NMTM_RESET_COMMUNICATION_req	0x0014 /* reset communication request */
#define	MS_NMTM_START_GUARD_REMOTE_NODE_req	0x0015 /* start CANopen remote node guarding request */
#define MS_NMTM_ADD_REMOTE_COP_NODE_GID_req	0x0016 /* add CANopen remote node with guard ID */

#define MS_NMTM_CONF_DOWNLOAD_START_req	0x0017 /* start config. download request */
#define MS_NMTM_CONF_DOWNLOAD_CONT_res	0x0018 /* continue config. download response */
#define MS_NMTM_CONF_UPLOAD_START_req	0x0019 /* start config. upload request */
#define MS_NMTM_CONF_ACKNOWLEDGE_res	0x001a /* config. data acknowledge (from host) */
#define MS_NMTM_CONF_DOWNLOAD_CONT_ind	0x001b /* config. download continue indication */
#define MS_NMTM_CONF_DOWNLOAD_SUC_con	0x001c /* config. download success confirmation */
#define MS_NMTM_CONF_DOWNLOAD_FAIL_con	0x001d /* config. download failure confirmation */
#define MS_NMTM_CONF_ABORT_TRANSFER_ind	0x001e /* config. transfer abort indication */
#define MS_NMTM_CONF_ABORT_TRANSFER_req	0x001f /* config. transfer abort indication */
#define MS_NMTM_CONF_VERIFY_req		0x0020 /* verify configuration transfer request */
#define MS_NMTM_CONF_VERIFY_con		0x0021 /* verify configuration transfer confirmation */


/* Message sub-specifiers with M_DBTM */
#define MS_DBTM_CREATE_COB_DEF_req	0x0000 /* create COB definitions */
#define MS_DBTM_DELETE_COB_DEF_req	0x0001 /* delete COB definitions */
#define MS_DBTM_CREATE_PRE_DEF_req	0x0002 /* create predefinitons */
#define MS_DBTM_DELETE_PRE_DEF_req	0x0003 /* delete predefinitons */
#define MS_DBTM_ENABLE_DIST_req		0x0004 /* enable COB database */
#define MS_DBTM_DISABLE_DIST_req	0x0005 /* disable COB database */
#define MS_DBTM_GET_COB_DB_req		0x0006 /* get COB database */
#define MS_DBTM_GET_COB_DB_con		0x0007 /* confirmation */
#define MS_DBTM_CONFIG_req		0x0008 /* configuration */

/* COB database list element specifiers */
#define CDB_STATE	1	/* ./. */
#define CDB_COB_DEF	2	/* ./. */
#define CDB_USR_DEF	3	/* ./. */
#define CDB_PRE_DEF	4	/* ./. */
 

/* Message sub-specifiers with M_CMS_DEF */
#define MS_CMS_DEFINITION_req		0x0000 /* CMS Definition */
#define MS_CMS_DEFINITION_con		0x0001 /* confirmation */
#define MS_CMS_OBJECT_CONF_req		0x0002 /* CMS Object configuration */
#define MS_CMS_SERVICE_CONF_req		0x0004 /* CMS service configuration */
#define MS_CMS_OBJECT_CHG_ID_req	0x0005 /* CMS Object change ID (SDO) */


/* Message sub-specifiers (mask: 0xff) with M_CMS_DATA */
#define MS_CMS_UPDATE_VAR		0x0001 /* update variable */
#define MS_CMS_WRITE_VAR_req		0x0002 /* write variable */
#define MS_CMS_READ_VAR_req		0x0003 /* read variable */
#define MS_CMS_NOTIFY_EVT_req		0x0004 /* notify event */
#define MS_CMS_STORE_EVT_req		0x0005 /* store event */
#define MS_CMS_STORE_I_EVT_req		0x0006 /* store event and notify */
#define MS_CMS_READ_EVT_req		0x0007 /* read data from stored event */
#define MS_CMS_DATA_ind			0x0009 /* data indication*/

#define MS_CMS_CONTROL_EVT_req		0x0008 /* set event state request */
#define MS_CMS_CONTROL_EVT_ind		0x000a /* set event state indication */
#define MS_CMS_CONTROL_EVT_res		0x000b /* set event state response */
#define MS_CMS_CONTROL_EVT_con		0x000c /* set event state confirm. */

#define MS_CMS_WRITE_VAR_ind		0x000d /* write variable indication */
#define MS_CMS_WRITE_VAR_res		0x000e /* write variable response */
#define MS_CMS_WRITE_VAR_con		0x000f /* write variable confirmation */

#define MS_CMS_READ_VAR_ind		0x0010 /* read variable indication */
#define MS_CMS_READ_VAR_res		0x0011 /* read variable response */
#define MS_CMS_READ_VAR_con		0x0012 /* read variable confirmation */

#define MS_CMS_FAIL_ind			0x0013 /* failure indication */

#define MS_CMS_WRITE_MUX_VAR_req	0x0014 /* write a mux variable */
#define MS_CMS_READ_MUX_VAR_req		0x0015 /* read a mux variable */



 
/* Domain sub specifiers (mask: 0xff00) with M_CMS_DATA */
#define	MS_CMS_DOWNLOAD_START_req	0x0100 /* start domain download */
#define MS_CMS_DOWNLOAD_CONT_res	0x0200 /* continue domain download */
#define MS_CMS_UPLOAD_START_req		0x0300 /* start domain upload */
#define MS_CMS_UPLOAD_res		0x0400 /* begin upload */
#define MS_CMS_UPLOAD_CONT_res		0x0500 /* continue upload */
#define MS_CMS_DOM_ABORT_req		0x0600 /* abort domain transfer */

#define	MS_CMS_DOM_DOWNLOAD_CONT_ind	0x0700 /* domain continue indication */
#define	MS_CMS_DOM_SUCCESS_con		0x0800 /* domain success confirmation */
#define	MS_CMS_DOM_SUCCESS_ind		0x0900 /* domain success indication */
#define	MS_CMS_DOM_FAILURE_con		0x0a00 /* domain failure confirmation */
#define	MS_CMS_DOM_FAILURE_ind		0x0b00 /* domain failure indication */
#define	MS_CMS_DOM_DATA_ind		0x0c00 /* domain data indication*/
#define	MS_CMS_DOM_EXPDATA_ind		0x0d00 /* ./. */
#define	MS_CMS_DOM_DATA_CONT_ind	0x0e00 /* domain data cont. indication */
#define	MS_CMS_DOM_UPLOAD_ind		0x0f00 /* domain upload indication */
#define	MS_CMS_DOM_UPLOAD_CONT_ind	0x1000 /* domain upload cont. indication */
#define MS_CMS_DOM_ACKNOWLEDGE_res	0x2000 /* domain acknowledge (from host) */
#define MS_CMS_DOM_RCPT_ACKNOWLEDGE_res	0x2100 /* domain receipt acknowledge (from host) */
#define MS_CMS_DOM_RESOLV_DELAY_ind	0x2000 /* internally used */

/* Failure codes (MS_CMS_FAIL_ind and MS_DOM_FAILURE) */
#define TRANSMIT_FAIL		1	/* transmitt failure */
#define DOM_PROT_ERR		2	/* domain protocol error */
#define NO_BUFFER		3	/* no free buffer (memory problem) */
#define ABORTED_BY_PEER		4	/* service aborted by peer object */
#define DATA_SIZE_ERR		5	/* wrong data size */
#define TIMED_OUT_ON_CON	6	/* timed out waiting for confirmation */
#define PROTOCOL_ERROR		7	/* protocol error */

/* some strategy codes concerning the host-guarding-stuff */
/* at failed guarding conditions */
#define	DISABLE_COB_DATABASE	0x01
#define	DISABLE_NODE_GUARDING	0x02
#define	DISCONNECT_REMOTE_NODES	0x04

#ifdef __cplusplus
}
#endif

#endif /* !mcal_DEFINED */
