#ifndef MARS_MCorsikaRead
#define MARS_MCorsikaRead

#ifndef MARS_MRead
#include "MRead.h"
#endif

class TList;
//class MZlib;
class MTaskList;

class MCorsikaRunHeader;
class MCorsikaEvtHeader;
class MPhotonEvent;
class MCorsikaFormat;

class MCorsikaRead : public MRead
{
private:
    MCorsikaRunHeader *fRunHeader;  //! run header information container to fill from file
    MCorsikaEvtHeader *fEvtHeader;  //! event header information container to fill from file
    MPhotonEvent      *fEvent;      //! event information

    Bool_t          fForceMode;     // Force mode skipping defect RUNE

    TList    *fFileNames;      // list of file names
    UInt_t    fNumFile;        //! number of next file
    UInt_t    fNumEvents;      //! input stream (file to read from)
    UInt_t    fNumTotalEvents; //! total number of events in all files

    ifstream *fIn;             //! input stream (file to read from)
	 MCorsikaFormat * fInFormat; //! access to input corsika data

    MParList *fParList;        //! tasklist to call ReInit from

    //UInt_t    fInterleave;
    //Bool_t    fForce;

    virtual Bool_t OpenStream() { return kTRUE; }

    Bool_t ReadEvtEnd();
    Int_t  OpenNextFile(Bool_t print=kTRUE);
    Bool_t CalcNumTotalEvents();
    Bool_t ReadEvent();

    Int_t PreProcess(MParList *pList);
    Int_t Process();
    Int_t PostProcess();

public:
    MCorsikaRead(const char *filename=NULL, const char *name=NULL, const char *title=NULL);
    ~MCorsikaRead();

    //static Byte_t IsFileValid(const char *name);

    //void SetInterleave(UInt_t i) { fInterleave = i; }
    void SetForceMode(Bool_t b=kTRUE) { fForceMode=b; }

    TString GetFullFileName() const;

    Int_t  AddFile(const char *fname, Int_t entries=-1);
    Bool_t Rewind();
    UInt_t GetEntries() { return fNumTotalEvents/*/fInterleave*/; }

    ClassDef(MCorsikaRead, 0)	// Task to read the raw data binary file
};

#endif
