/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void readCT1()
{
    MParList plist;

    MGeomCamCT1 geomcam;
    MHillas     hillas;
    MTaskList   tlist;

    plist->AddToList(&geomcam);
    plist->AddToList(&hillas);
    plist->AddToList(&tlist);

    MCT1ReadAscii read("CT1_99_off1.dat");
    MImgCleanStd  clean;
    MHillasCalc   hcalc;

    tlist.AddToList(&read);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);

    MEvtLoop evtloop;
    evtloop.SetParList(&plist);

    if (!evtloop.PreProcess())
        return;

    MCerPhotEvt &phevt = *(MCerPhotEvt*)plist->FindObject("MCerPhotEvt");

    Int_t icount = 0;
    MCamDisplay display(&geomcam);
        display.DrawPhotNum(&phevt);


    while (read.Process())
    {
        cout << "Event: " << icount++  << endl;

        display.DrawPhotNum(&phevt);
        gClient->HandleInput();
        if(getchar()=='q')
            break;

        clean.Process();

        if (hcalc.Process()==kCONTINUE)
        {
            cout << "skipped." << endl;
            continue;
        }

        hillas.Print();
        hillas.Draw();

        display.DrawPhotNum(&phevt);

        gClient->HandleInput();
        if(getchar()=='q')
            break;

        hillas.Clear();
    } 

    evtloop.PostProcess();
}
